/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.background.task;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Objects;

public class WorkflowMetricsReindexBackgroundTaskStatusMessageTranslator
implements BackgroundTaskStatusMessageTranslator {
    public void translate(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String phase = message.getString("phase");
        if (Validator.isNotNull((String)phase)) {
            this._setPhaseAttributes(backgroundTaskStatus, message);
            return;
        }
        String indexEntityName = message.getString("indexEntityName");
        long count = message.getLong("count");
        long total = message.getLong("total");
        int percentage = 0;
        if (Validator.isNull((String)indexEntityName)) {
            percentage = (int)((double)(count + 1L) / (double)total * 100.0);
        } else {
            String[] indexEntityNames = (String[])backgroundTaskStatus.getAttribute("indexEntityNames");
            int index = -1;
            for (int i = 0; i < indexEntityNames.length; ++i) {
                if (!Objects.equals(indexEntityNames[i], indexEntityName)) continue;
                index = i;
                break;
            }
            percentage = this._getPercentage(count, index, indexEntityNames.length, total);
        }
        backgroundTaskStatus.setAttribute("percentage", (Serializable)Integer.valueOf(Math.max(GetterUtil.getInteger((Object)backgroundTaskStatus.getAttribute("percentage")), percentage)));
    }

    private int _getPercentage(long count, int indexerCount, int indexerTotal, long total) {
        if (total <= 0L || indexerTotal <= 0) {
            return 100;
        }
        double indexerPercentage = (double)count / (double)total;
        double totalPercentage = ((double)indexerCount + indexerPercentage) / (double)indexerTotal;
        return (int)Math.min(Math.ceil(totalPercentage * 100.0), 100.0);
    }

    private void _setPhaseAttributes(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        Object[] indexEntityNames = (String[])message.get("indexEntityNames");
        backgroundTaskStatus.setAttribute("companyId", (Serializable)Long.valueOf(message.getLong("companyId")));
        if (ArrayUtil.isNotEmpty((Object[])indexEntityNames)) {
            backgroundTaskStatus.setAttribute("indexEntityName", (Serializable)indexEntityNames[0]);
            backgroundTaskStatus.setAttribute("indexEntityNames", (Serializable)indexEntityNames);
        }
        backgroundTaskStatus.setAttribute("phase", (Serializable)((Object)message.getString("phase")));
    }
}

