/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.background.task;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsReindexBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.workflow.metrics.internal.petra.executor.WorkflowMetricsPortalExecutor;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexerRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsReindexBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class WorkflowMetricsReindexBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    @Reference
    private BackgroundTaskStatusMessageSender _backgroundTaskStatusMessageSender;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private WorkflowMetricsPortalExecutor _workflowMetricsPortalExecutor;
    @Reference
    private WorkflowMetricsReindexerRegistry _workflowMetricsReindexerRegistry;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public WorkflowMetricsReindexBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new WorkflowMetricsReindexBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(2);
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        String indexEntityName;
        void var5_7;
        String[] indexEntityNames = this._getIndexEntityNames(backgroundTask);
        this._sendStatusMessage(backgroundTask.getCompanyId(), "start", indexEntityNames);
        this._workflowMetricsReindexStatusMessageSender.sendStatusMessage(0L, (long)indexEntityNames.length, "");
        String[] stringArray = indexEntityNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            indexEntityName = stringArray[var5_7];
            WorkflowMetricsIndex workflowMetricsIndex = WorkflowMetricsIndex.toWorkflowMetricsIndex(indexEntityName);
            workflowMetricsIndex.deleteAllDocuments(this._searchCapabilities, this._searchEngineAdapter, this._queries, this._indexNameBuilder, backgroundTask.getCompanyId());
            ++var5_7;
        }
        ArrayList noticeableFutures = new ArrayList();
        for (int i = 0; i < indexEntityNames.length; ++i) {
            int n2 = i + 1;
            indexEntityName = indexEntityNames[i];
            noticeableFutures.add(this._workflowMetricsPortalExecutor.execute(() -> {
                WorkflowMetricsReindexer workflowMetricsReindexer = this._workflowMetricsReindexerRegistry.getWorkflowMetricsReindexer(indexEntityName);
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)backgroundTask.getCompanyId());){
                    workflowMetricsReindexer.reindex(backgroundTask.getCompanyId());
                }
                this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)count, (long)indexEntityNames.length, "");
            }));
        }
        for (NoticeableFuture noticeableFuture : noticeableFutures) {
            noticeableFuture.get();
        }
        this._sendStatusMessage(backgroundTask.getCompanyId(), "end", new String[0]);
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    private String[] _getIndexEntityNames(BackgroundTask backgroundTask) {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        List indexEntityNames = ListUtil.sort((List)TransformUtil.transformToList((Object[])((String[])taskContextMap.get("workflow.metrics.index.entity.names")), name -> {
            if (this._workflowMetricsReindexerRegistry.containsKey(name)) {
                return name;
            }
            return null;
        }), Comparator.comparing(indexEntityName -> indexEntityName.startsWith("sla")));
        return indexEntityNames.toArray(new String[0]);
    }

    private void _sendStatusMessage(long companyId, String phase, String ... indexEntityNames) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        message.put("companyId", (Object)companyId);
        if (ArrayUtil.isNotEmpty((Object[])indexEntityNames)) {
            message.put("indexEntityName", (Object)indexEntityNames[0]);
            message.put("indexEntityNames", (Object)indexEntityNames);
        }
        message.put("phase", (Object)phase);
        message.put("status", (Object)1);
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }
}

