/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener.BaseKaleoModelListener;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.metrics.search.index.TransitionWorkflowMetricsIndexer;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoTransitionModelListener
extends BaseKaleoModelListener<KaleoTransition> {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private TransitionWorkflowMetricsIndexer _transitionWorkflowMetricsIndexer;

    public void onAfterCreate(KaleoTransition kaleoTransition) {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoTransition.getKaleoDefinitionVersionId());
        if (Objects.isNull(kaleoDefinitionVersion)) {
            return;
        }
        try {
            this._transitionWorkflowMetricsIndexer.addTransition(this._indexerHelper.createAddTransitionRequest(kaleoTransition, kaleoDefinitionVersion.getVersion()));
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterRemove(KaleoTransition kaleoTransition) {
        this._transitionWorkflowMetricsIndexer.deleteTransition(this._indexerHelper.createDeleteTransitionRequest(kaleoTransition));
    }
}

