/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.search.index.reindexer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.InstanceWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsReindexer.class})
public class InstanceWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private InstanceWorkflowMetricsIndexer _instanceWorkflowMetricsIndexer;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public String getKey() {
        return "instance";
    }

    public void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoInstanceLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(kaleoInstance -> {
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoInstance.getKaleoDefinitionVersionId());
            if (Objects.isNull(kaleoDefinitionVersion)) {
                return;
            }
            this._instanceWorkflowMetricsIndexer.addInstance(this._indexerHelper.createAssetTitleLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getClassPK(), kaleoInstance.getGroupId()), this._indexerHelper.createAssetTypeLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getGroupId()), kaleoInstance.getClassName(), kaleoInstance.getClassPK(), companyId, kaleoInstance.getCompletionDate(), kaleoInstance.getCreateDate(), kaleoInstance.getKaleoInstanceId(), kaleoInstance.getModifiedDate(), kaleoInstance.getKaleoDefinitionId(), kaleoDefinitionVersion.getVersion(), kaleoInstance.getUserId(), kaleoInstance.getUserName());
            this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "instance");
        });
        actionableDynamicQuery.performActions();
    }
}

