/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener.BaseKaleoModelListener;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.metrics.model.CompleteTaskRequest;
import com.liferay.portal.workflow.metrics.model.DeleteTaskRequest;
import com.liferay.portal.workflow.metrics.model.UpdateTaskRequest;
import com.liferay.portal.workflow.metrics.search.index.TaskWorkflowMetricsIndexer;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoTaskInstanceTokenModelListener
extends BaseKaleoModelListener<KaleoTaskInstanceToken> {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private TaskWorkflowMetricsIndexer _taskWorkflowMetricsIndexer;

    public void onAfterCreate(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
            if (Objects.isNull(kaleoDefinitionVersion)) {
                return null;
            }
            this._taskWorkflowMetricsIndexer.addTask(this._indexerHelper.createAddTaskRequest(null, kaleoTaskInstanceToken, kaleoDefinitionVersion.getVersion()));
            return null;
        });
    }

    public void onAfterUpdate(KaleoTaskInstanceToken originalKaleoTaskInstanceToken, KaleoTaskInstanceToken kaleoTaskInstanceToken) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            List kaleoTaskAssignmentInstances = this._kaleoTaskAssignmentInstanceLocalService.getKaleoTaskAssignmentInstances(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
            if (!kaleoTaskAssignmentInstances.isEmpty()) {
                UpdateTaskRequest.Builder updateTaskRequestBuilder = new UpdateTaskRequest.Builder();
                this._taskWorkflowMetricsIndexer.updateTask(updateTaskRequestBuilder.assetTitleMap(this._indexerHelper.createAssetTitleLocalizationMap(kaleoTaskInstanceToken.getClassName(), kaleoTaskInstanceToken.getClassPK(), kaleoTaskInstanceToken.getGroupId())).assetTypeMap(this._indexerHelper.createAssetTypeLocalizationMap(kaleoTaskInstanceToken.getClassName(), kaleoTaskInstanceToken.getGroupId())).assignments(this._indexerHelper.toAssignments(kaleoTaskAssignmentInstances)).companyId(kaleoTaskInstanceToken.getCompanyId()).modifiedDate(kaleoTaskInstanceToken.getModifiedDate()).taskId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()).userId(kaleoTaskInstanceToken.getUserId()).build());
            }
            return null;
        });
    }

    public void onBeforeRemove(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws ModelListenerException {
        DeleteTaskRequest.Builder deleteTaskRequestBuilder = new DeleteTaskRequest.Builder();
        this._taskWorkflowMetricsIndexer.deleteTask(deleteTaskRequestBuilder.companyId(kaleoTaskInstanceToken.getCompanyId()).taskId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()).build());
    }

    public void onBeforeUpdate(KaleoTaskInstanceToken originalKaleoTaskInstanceToken, KaleoTaskInstanceToken kaleoTaskInstanceToken) throws ModelListenerException {
        KaleoTaskInstanceToken currentKaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.fetchKaleoTaskInstanceToken(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        if (currentKaleoTaskInstanceToken.isCompleted() || !kaleoTaskInstanceToken.isCompleted()) {
            return;
        }
        CompleteTaskRequest.Builder completeTaskRequestBuilder = new CompleteTaskRequest.Builder();
        this._taskWorkflowMetricsIndexer.completeTask(completeTaskRequestBuilder.companyId(kaleoTaskInstanceToken.getCompanyId()).completionDate(kaleoTaskInstanceToken.getCompletionDate()).completionUserId(Long.valueOf(kaleoTaskInstanceToken.getCompletionUserId())).duration(() -> {
            Date createDate = kaleoTaskInstanceToken.getCreateDate();
            Date completionDate = kaleoTaskInstanceToken.getCompletionDate();
            Duration duration = Duration.between(createDate.toInstant(), completionDate.toInstant());
            return duration.toMillis();
        }).modifiedDate(kaleoTaskInstanceToken.getModifiedDate()).taskId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()).userId(kaleoTaskInstanceToken.getUserId()).build());
    }
}

