/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.search.index.reindexer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.ProcessWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsReindexer.class})
public class ProcessWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private ProcessWorkflowMetricsIndexer _processWorkflowMetricsIndexer;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public String getKey() {
        return "process";
    }

    public void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoDefinitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(kaleoDefinition -> {
            this._processWorkflowMetricsIndexer.addProcess(this._indexerHelper.createAddProcessRequest(companyId, (KaleoDefinition)kaleoDefinition));
            this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "process");
        });
        actionableDynamicQuery.performActions();
    }
}

