/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener;

import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener.BaseKaleoModelListener;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.metrics.search.index.InstanceWorkflowMetricsIndexer;
import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoInstanceModelListener
extends BaseKaleoModelListener<KaleoInstance> {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private InstanceWorkflowMetricsIndexer _instanceWorkflowMetricsIndexer;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;

    public void onAfterCreate(KaleoInstance kaleoInstance) {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoInstance.getKaleoDefinitionVersionId());
        if (Objects.isNull(kaleoDefinitionVersion)) {
            return;
        }
        this._instanceWorkflowMetricsIndexer.addInstance(this._indexerHelper.createAssetTitleLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getClassPK(), kaleoInstance.getGroupId()), this._indexerHelper.createAssetTypeLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getGroupId()), kaleoInstance.getClassName(), kaleoInstance.getClassPK(), kaleoInstance.getCompanyId(), null, kaleoInstance.getCreateDate(), kaleoInstance.getKaleoInstanceId(), kaleoInstance.getModifiedDate(), kaleoInstance.getKaleoDefinitionId(), kaleoDefinitionVersion.getVersion(), kaleoInstance.getUserId(), kaleoInstance.getUserName());
    }

    public void onAfterRemove(KaleoInstance kaleoInstance) {
        this._instanceWorkflowMetricsIndexer.deleteInstance(kaleoInstance.getCompanyId(), kaleoInstance.getKaleoInstanceId());
    }

    public void onBeforeUpdate(KaleoInstance originalKaleoInstance, KaleoInstance kaleoInstance) {
        KaleoInstance currentKaleoInstance = this._kaleoInstanceLocalService.fetchKaleoInstance(kaleoInstance.getKaleoInstanceId());
        if (!currentKaleoInstance.isCompleted() && kaleoInstance.isCompleted()) {
            Date createDate = kaleoInstance.getCreateDate();
            Date completionDate = kaleoInstance.getCompletionDate();
            Duration duration = Duration.between(createDate.toInstant(), completionDate.toInstant());
            this._instanceWorkflowMetricsIndexer.completeInstance(kaleoInstance.getCompanyId(), kaleoInstance.getCompletionDate(), duration.toMillis(), kaleoInstance.getKaleoInstanceId(), kaleoInstance.getModifiedDate());
        } else {
            this._instanceWorkflowMetricsIndexer.updateInstance(kaleoInstance.isActive(), this._indexerHelper.createAssetTitleLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getClassPK(), kaleoInstance.getGroupId()), this._indexerHelper.createAssetTypeLocalizationMap(kaleoInstance.getClassName(), kaleoInstance.getGroupId()), kaleoInstance.getCompanyId(), kaleoInstance.getKaleoInstanceId(), kaleoInstance.getModifiedDate());
        }
    }
}

