/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.search.index.reindexer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.TaskWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsReindexer.class})
public class TaskWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private TaskWorkflowMetricsIndexer _taskWorkflowMetricsIndexer;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public String getKey() {
        return "task";
    }

    public void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTaskInstanceTokenLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(kaleoTaskInstanceToken -> {
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
            if (Objects.isNull(kaleoDefinitionVersion)) {
                return;
            }
            KaleoInstance kaleoInstance = this._kaleoInstanceLocalService.fetchKaleoInstance(kaleoTaskInstanceToken.getKaleoInstanceId());
            if (Objects.isNull(kaleoInstance)) {
                return;
            }
            this._taskWorkflowMetricsIndexer.addTask(this._indexerHelper.createAddTaskRequest(kaleoInstance, (KaleoTaskInstanceToken)kaleoTaskInstanceToken, kaleoDefinitionVersion.getVersion()));
            this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "task");
        });
        actionableDynamicQuery.performActions();
    }
}

