/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener;

import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener.BaseKaleoModelListener;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.metrics.model.DeleteNodeRequest;
import com.liferay.portal.workflow.metrics.search.index.NodeWorkflowMetricsIndexer;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoNodeModelListener
extends BaseKaleoModelListener<KaleoNode> {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private NodeWorkflowMetricsIndexer _nodeWorkflowMetricsIndexer;

    public void onAfterCreate(KaleoNode kaleoNode) {
        if (!Objects.equals(kaleoNode.getType(), NodeType.STATE.name())) {
            return;
        }
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoNode.getKaleoDefinitionVersionId());
        if (Objects.isNull(kaleoDefinitionVersion)) {
            return;
        }
        this._nodeWorkflowMetricsIndexer.addNode(this._indexerHelper.createAddNodeRequest(kaleoDefinitionVersion, kaleoNode));
    }

    public void onAfterRemove(KaleoNode kaleoNode) {
        if (!Objects.equals(kaleoNode.getType(), NodeType.STATE.name())) {
            return;
        }
        DeleteNodeRequest.Builder builder = new DeleteNodeRequest.Builder();
        this._nodeWorkflowMetricsIndexer.deleteNode(builder.companyId(kaleoNode.getCompanyId()).nodeId(kaleoNode.getKaleoNodeId()).build());
    }
}

