/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.search.index.reindexer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.TransitionWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"workflow.metrics.index.entity.name=transition"}, service={WorkflowMetricsReindexer.class})
public class TransitionWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private TransitionWorkflowMetricsIndexer _transitionWorkflowMetricsIndexer;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTransitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(kaleoTransition -> {
            if (kaleoTransition == null) {
                return;
            }
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoTransition.getKaleoDefinitionVersionId());
            this._transitionWorkflowMetricsIndexer.addTransition(this._indexerHelper.createAddTransitionRequest((KaleoTransition)kaleoTransition, kaleoDefinitionVersion.getVersion()));
            this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "transition");
        });
        actionableDynamicQuery.performActions();
    }
}

