/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.search.index.reindexer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.search.index.NodeWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"workflow.metrics.index.entity.name=node"}, service={WorkflowMetricsReindexer.class})
public class NodeWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private NodeWorkflowMetricsIndexer _nodeWorkflowMetricsIndexer;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;

    public void reindex(long companyId) throws PortalException {
        this._reindexIndexWithKaleoNode(companyId);
        this._reindexIndexWithKaleoTask(companyId);
    }

    private void _reindexIndexWithKaleoNode(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoNodeLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)NodeType.STATE.name()));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoNode -> {
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoNode.getKaleoDefinitionVersionId());
            if (Objects.isNull(kaleoDefinitionVersion)) {
                return;
            }
            this._nodeWorkflowMetricsIndexer.addNode(this._indexerHelper.createAddNodeRequest(kaleoDefinitionVersion, (KaleoNode)kaleoNode));
        });
        actionableDynamicQuery.performActions();
    }

    private void _reindexIndexWithKaleoTask(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTaskLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(kaleoTask -> {
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoTask.getKaleoDefinitionVersionId());
            if (Objects.isNull(kaleoDefinitionVersion)) {
                return;
            }
            this._nodeWorkflowMetricsIndexer.addNode(this._indexerHelper.createAddNodeRequest(kaleoDefinitionVersion, (KaleoTask)kaleoTask));
            this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "node");
        });
        actionableDynamicQuery.performActions();
    }
}

