/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener;

import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.helper.IndexerHelper;
import com.liferay.portal.workflow.kaleo.metrics.integration.internal.model.listener.BaseKaleoModelListener;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.metrics.model.DeleteNodeRequest;
import com.liferay.portal.workflow.metrics.search.index.NodeWorkflowMetricsIndexer;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoTaskModelListener
extends BaseKaleoModelListener<KaleoTask> {
    @Reference
    private IndexerHelper _indexerHelper;
    @Reference
    private NodeWorkflowMetricsIndexer _nodeWorkflowMetricsIndexer;

    public void onAfterCreate(KaleoTask kaleoTask) {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoTask.getKaleoDefinitionVersionId());
        if (Objects.isNull(kaleoDefinitionVersion)) {
            return;
        }
        this._nodeWorkflowMetricsIndexer.addNode(this._indexerHelper.createAddNodeRequest(kaleoDefinitionVersion, kaleoTask));
    }

    public void onAfterRemove(KaleoTask kaleoTask) {
        DeleteNodeRequest.Builder builder = new DeleteNodeRequest.Builder();
        this._nodeWorkflowMetricsIndexer.deleteNode(builder.companyId(kaleoTask.getCompanyId()).nodeId(kaleoTask.getKaleoTaskId()).build());
    }
}

