/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.tools.service.builder.Entity;
import com.liferay.portal.tools.service.builder.EntityColumn;
import com.liferay.portal.tools.service.builder.ServiceBuilder;
import java.util.ArrayList;
import java.util.List;

public class EntityFinder {
    private final List<EntityColumn> _arrayableColumns = new ArrayList<EntityColumn>();
    private final boolean _dbIndex;
    private final String _dbWhere;
    private final List<EntityColumn> _entityColumns;
    private final String _name;
    private final String _pluralName;
    private final boolean _pretouch;
    private final String _returnType;
    private final ServiceBuilder _serviceBuilder;
    private final boolean _unique;
    private final String _where;

    public EntityFinder(ServiceBuilder serviceBuilder, String name, String pluralName, boolean pretouch, String returnType, boolean unique, String where, String dbWhere, boolean dbIndex, List<EntityColumn> entityColumns) {
        this._serviceBuilder = serviceBuilder;
        this._name = name;
        this._pluralName = GetterUtil.getString(pluralName, serviceBuilder.formatPlural(name));
        this._pretouch = pretouch;
        this._returnType = returnType;
        this._unique = unique;
        this._where = where;
        this._dbWhere = dbWhere;
        this._dbIndex = dbIndex;
        this._entityColumns = entityColumns;
        for (EntityColumn column : this._entityColumns) {
            if (!column.hasArrayableOperator()) continue;
            this._arrayableColumns.add(column);
        }
        if (this.isCollection() && this.isUnique() && !this.hasArrayableOperator()) {
            throw new IllegalArgumentException("A finder cannot return a Collection and be unique unless it has an arrayable column. See the ExpandoColumn service.xml declaration for an example.");
        }
        if ((!this.isCollection() || this.isUnique()) && this.hasCustomComparator()) {
            throw new IllegalArgumentException("A unique finder cannot have a custom comparator");
        }
    }

    public List<EntityColumn> getArrayableColumns() {
        return this._arrayableColumns;
    }

    public String getDBWhere() {
        return this._dbWhere;
    }

    public EntityColumn getEntityColumn(String name) {
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!name.equals(entityColumn.getName())) continue;
            return entityColumn;
        }
        return null;
    }

    public List<EntityColumn> getEntityColumns() {
        return this._entityColumns;
    }

    public String getHumanConditions(boolean arrayable) {
        if (this._entityColumns.size() == 1) {
            EntityColumn entityColumn = this._entityColumns.get(0);
            return entityColumn.getHumanCondition(arrayable);
        }
        StringBundler sb = new StringBundler(this._entityColumns.size() * 2);
        for (EntityColumn column : this._entityColumns) {
            sb.append(column.getHumanCondition(arrayable));
            sb.append(" and ");
        }
        if (!this._entityColumns.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getPluralName() {
        return this._pluralName;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getWhere() {
        return this._where;
    }

    public boolean hasArrayableOperator() {
        for (EntityColumn column : this._entityColumns) {
            if (!column.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasArrayablePagination() {
        for (EntityColumn column : this._entityColumns) {
            if (!column.hasArrayablePagination()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomComparator() {
        for (EntityColumn column : this._entityColumns) {
            String comparator = column.getComparator();
            if (comparator.equals("=")) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntityColumn(String name) {
        return Entity.hasEntityColumn(this._serviceBuilder, name, this._entityColumns);
    }

    public boolean isCollection() {
        return this._returnType != null && this._returnType.equals("Collection");
    }

    public boolean isDBIndex() {
        return this._dbIndex;
    }

    public boolean isPretouch() {
        return this._pretouch;
    }

    public boolean isUnique() {
        return this._unique;
    }
}

