/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GitUtil {
    public static String getCurrentBranchFileContent(String gitWorkingBranchName, String fileName) throws Exception {
        return GitUtil.getFileContent(gitWorkingBranchName, fileName);
    }

    public static List<String> getCurrentBranchFileNames(String baseDirName, String gitWorkingBranchName) throws Exception {
        return GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName, false);
    }

    public static List<String> getCurrentBranchFileNames(String baseDirName, String gitWorkingBranchName, boolean includeDeletedFileNames) throws Exception {
        String commitId = GitUtil.getCurrentBranchCommitId(gitWorkingBranchName);
        List<String> fileNames = GitUtil.getFileNames(baseDirName, commitId);
        if (includeDeletedFileNames) {
            fileNames.addAll(GitUtil.getDeletedFileNames(baseDirName, commitId));
        }
        return fileNames;
    }

    public static String getLatestAuthorFileContent(String fileName) throws Exception {
        return GitUtil.getFileContent(GitUtil.getLatestAuthorCommitId(), fileName);
    }

    public static List<String> getLatestAuthorFileNames(String baseDirName) throws Exception {
        return GitUtil.getLatestAuthorFileNames(baseDirName, false);
    }

    public static List<String> getLatestAuthorFileNames(String baseDirName, boolean includeDeletedFileNames) throws Exception {
        String commitId = GitUtil.getLatestAuthorCommitId();
        List<String> fileNames = GitUtil.getFileNames(baseDirName, commitId);
        if (includeDeletedFileNames) {
            fileNames.addAll(GitUtil.getDeletedFileNames(baseDirName, commitId));
        }
        return fileNames;
    }

    public static String getLocalChangesFileContent(String fileName) throws Exception {
        return GitUtil.getFileContent("HEAD", fileName);
    }

    public static List<String> getLocalChangesFileNames(String baseDirName) throws Exception {
        return GitUtil.getLocalChangesFileNames(baseDirName, false);
    }

    public static List<String> getLocalChangesFileNames(String baseDirName, boolean includeDeletedFileNames) throws Exception {
        List<String> fileNames = GitUtil.getLocalChangesFileNames(baseDirName, "add");
        if (includeDeletedFileNames) {
            fileNames.addAll(GitUtil.getLocalChangesFileNames(baseDirName, "remove"));
        }
        return fileNames;
    }

    public static List<String> getModifiedLastDayFileNames(String baseDirName) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git diff --diff-filter=AMR --name-only --stat @{last.day}");
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.count(line, '/') < gitLevel) continue;
            fileNames.add(GitUtil.getFileName(line, gitLevel));
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String quiet = System.getProperty("system.properties.quiet");
        System.setProperty("system.properties.quiet", "true");
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String baseDirName = ArgumentsUtil.getString(arguments, "git.base.dir", "./");
        String type = ArgumentsUtil.getString(arguments, "git.type", "current-branch");
        try {
            Collection<String> fileNames = null;
            if (type.equals("current-branch")) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                fileNames = GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName, false);
            } else if (type.equals("latest-author")) {
                fileNames = GitUtil.getLatestAuthorFileNames(baseDirName, false);
            } else if (type.equals("local-changes")) {
                fileNames = GitUtil.getLocalChangesFileNames(baseDirName, false);
            } else {
                throw new IllegalArgumentException();
            }
            String markerFileName = ArgumentsUtil.getString(arguments, "git.marker.file", null);
            if (Validator.isNotNull(markerFileName)) {
                fileNames = GitUtil.getDirNames(baseDirName, fileNames, markerFileName);
            }
            for (String fileName : fileNames) {
                System.out.println(fileName);
            }
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
        finally {
            if (quiet == null) {
                System.clearProperty("system.properties.quiet");
            } else {
                System.setProperty("system.properties.quiet", quiet);
            }
        }
    }

    protected static String getCurrentBranchCommitId(String gitWorkingBranchName) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git merge-base HEAD " + gitWorkingBranchName);
        return unsyncBufferedReader.readLine();
    }

    protected static List<String> getDeletedFileNames(String baseDirName, String commitId) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git rev-parse HEAD");
        String latestCommitId = unsyncBufferedReader.readLine();
        unsyncBufferedReader = GitUtil.getGitCommandReader(StringBundler.concat("git diff --diff-filter=RD --name-status ", commitId, " ", latestCommitId));
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] array = line.split("\\s+");
            if (array.length < 2 || StringUtil.count(array[1], '/') < gitLevel) continue;
            fileNames.add(GitUtil.getFileName(array[1], gitLevel));
        }
        return fileNames;
    }

    protected static Set<String> getDirNames(String baseDirName, Iterable<String> fileNames, String markerFileName) {
        File baseDir = new File(baseDirName);
        Path baseDirPath = baseDir.toPath();
        HashSet<String> dirNames = new HashSet<String>();
        for (String fileName : fileNames) {
            File file = new File(baseDir, fileName);
            File dir = GitUtil.getRootDir(file.getParentFile(), baseDir, markerFileName);
            if (dir == null) continue;
            String dirName = String.valueOf(baseDirPath.relativize(dir.toPath()));
            dirName = StringUtil.replace(dirName, File.separatorChar, '/');
            dirNames.add(dirName);
        }
        return dirNames;
    }

    protected static String getFileContent(String committish, String fileName) throws Exception {
        StringBundler sb = new StringBundler();
        String gitCommand = StringBundler.concat("git show ", committish, ":", fileName);
        try (UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader(gitCommand);){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    protected static String getFileName(String fileName, int gitLevel) {
        for (int i = 0; i < gitLevel; ++i) {
            int x = fileName.indexOf("/");
            fileName = fileName.substring(x + 1);
        }
        return fileName;
    }

    protected static List<String> getFileNames(String baseDirName, String commitId) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git rev-parse HEAD");
        String latestCommitId = unsyncBufferedReader.readLine();
        unsyncBufferedReader = GitUtil.getGitCommandReader(StringBundler.concat("git diff --diff-filter=AMR --name-only ", commitId, " ", latestCommitId));
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.count(line, '/') < gitLevel) continue;
            fileNames.add(GitUtil.getFileName(line, gitLevel));
        }
        return fileNames;
    }

    protected static UnsyncBufferedReader getGitCommandReader(String gitCommand) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(gitCommand);
        }
        catch (IOException ioe) {
            String errorMessage = ioe.getMessage();
            if (errorMessage.contains("Cannot run program")) {
                throw new GitException("Add Git to your PATH system variable first");
            }
            throw ioe;
        }
        return new UnsyncBufferedReader(new InputStreamReader(process.getInputStream()));
    }

    protected static int getGitLevel(String baseDirName) throws GitException {
        File dir = new File(baseDirName);
        dir = dir.getAbsoluteFile();
        for (int i = 0; i < 7; ++i) {
            if (dir == null || !dir.exists()) continue;
            File gitFile = new File(dir, ".git");
            if (gitFile.exists()) {
                return i;
            }
            dir = dir.getParentFile();
        }
        throw new GitException("Unable to retrieve files because .git directory is missing");
    }

    protected static String getLatestAuthorCommitId() throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git log");
        String line = null;
        String firstDifferentAuthorCommitId = null;
        String latestAuthor = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("commit ")) {
                firstDifferentAuthorCommitId = line.substring(7);
                continue;
            }
            if (!line.startsWith("Author: ")) continue;
            if (latestAuthor == null) {
                int x = line.lastIndexOf(60);
                int y = line.lastIndexOf(62);
                latestAuthor = line.substring(x + 1, y);
                continue;
            }
            if (line.endsWith("<" + latestAuthor + ">")) continue;
            break;
        }
        return firstDifferentAuthorCommitId;
    }

    protected static List<String> getLocalChangesFileNames(String baseDirName, String command) throws Exception {
        ArrayList<String> localChangesFileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git add . --dry-run");
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.count(line, '/') < gitLevel || Validator.isNull(command) || !line.startsWith(command + " '")) continue;
            String fileName = line.substring(command.length() + 2, line.length() - 1);
            localChangesFileNames.add(GitUtil.getFileName(fileName, gitLevel));
        }
        return localChangesFileNames;
    }

    protected static File getRootDir(File dir, File baseDir, String markerFileName) {
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null && !baseDir.equals(dir));
        return null;
    }
}

