/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.template.BaseTemplateResourceCache;
import com.liferay.portal.template.BaseTemplateResourceLoader;
import com.liferay.portal.template.engine.BaseTemplateManager;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration;
import com.liferay.portal.template.velocity.internal.FastExtendedProperties;
import com.liferay.portal.template.velocity.internal.LiferayMethodExceptionEventHandler;
import com.liferay.portal.template.velocity.internal.LiferayResourceLoader;
import com.liferay.portal.template.velocity.internal.LiferayResourceManager;
import com.liferay.portal.template.velocity.internal.LiferaySecureUberspector;
import com.liferay.portal.template.velocity.internal.VelocityParserPool;
import com.liferay.portal.template.velocity.internal.VelocityTemplate;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.VelocityEngine;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration"}, property={"language.type=vm"}, service={TemplateManager.class})
public class VelocityManager
extends BaseTemplateManager {
    private static volatile VelocityEngineConfiguration _velocityEngineConfiguration;
    @Reference(target="(component.name=com.liferay.portal.template.velocity.internal.helper.VelocityTemplateContextHelper)")
    private TemplateContextHelper _templateContextHelper;
    private ServiceRegistration<TemplateResourceLoader> _templateResourceLoaderServiceRegistration;
    private VelocityEngine _velocityEngine;
    private VelocityTemplateResourceCache _velocityTemplateResourceCache;
    private volatile VelocityTemplateResourceLoader _velocityTemplateResourceLoader;

    public String getName() {
        return "vm";
    }

    public String[] getRestrictedVariables() {
        return _velocityEngineConfiguration.restrictedVariables();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws TemplateException {
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
        this._velocityTemplateResourceCache = new VelocityTemplateResourceCache();
        this._velocityTemplateResourceLoader = new VelocityTemplateResourceLoader(bundleContext, (TemplateResourceCache)this._velocityTemplateResourceCache);
        this._templateResourceLoaderServiceRegistration = bundleContext.registerService(TemplateResourceLoader.class, (Object)this._velocityTemplateResourceLoader, null);
        this._init();
    }

    @Deactivate
    protected void deactivate() {
        this._destroy();
        this._templateResourceLoaderServiceRegistration.unregister();
        this._velocityTemplateResourceCache.destroy();
        this._velocityTemplateResourceLoader.destroy();
    }

    protected Template doGetTemplate(TemplateResource templateResource, boolean restricted, Map<String, Object> helperUtilities) {
        return new VelocityTemplate(templateResource, helperUtilities, this._velocityEngine, this._templateContextHelper, (TemplateResourceCache)this._velocityTemplateResourceCache, restricted);
    }

    protected TemplateContextHelper getTemplateContextHelper() {
        return this._templateContextHelper;
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws TemplateException {
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
        this._destroy();
        this._init();
    }

    private void _destroy() {
        if (this._velocityEngine == null) {
            return;
        }
        this._velocityEngine = null;
        this._templateContextHelper.removeAllHelperUtilities();
    }

    private String[] _filterRestrictedClasses(String[] restrictedClasses) {
        if (JavaDetector.isJDK21()) {
            return ArrayUtil.remove((String[])restrictedClasses, (String)"java.lang.Compiler");
        }
        return restrictedClasses;
    }

    private String _getVelocimacroLibrary(Class<?> clazz) {
        String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
        contextName = contextName.concat("_CLASS_LOADER_CONTEXT_");
        String[] velocimacroLibrary = _velocityEngineConfiguration.velocimacroLibrary();
        StringBundler sb = new StringBundler(3 * velocimacroLibrary.length);
        for (String library : velocimacroLibrary) {
            sb.append(contextName);
            sb.append(library);
            sb.append(",");
        }
        if (velocimacroLibrary.length > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private void _init() throws TemplateException {
        if (this._velocityEngine != null) {
            return;
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)VelocityManager.class.getClassLoader());){
            this._velocityEngine = new VelocityEngine();
            FastExtendedProperties extendedProperties = new FastExtendedProperties();
            extendedProperties.setProperty("introspector.restrict.classes", StringUtil.merge((Object[])this._filterRestrictedClasses(_velocityEngineConfiguration.restrictedClasses())));
            extendedProperties.setProperty("introspector.restrict.packages", StringUtil.merge((Object[])_velocityEngineConfiguration.restrictedPackages()));
            extendedProperties.setProperty("parser.pool.class", VelocityParserPool.class.getName());
            extendedProperties.setProperty("runtime.introspector.uberspect", LiferaySecureUberspector.class.getName());
            extendedProperties.setProperty("directive.if.tostring.nullcheck", String.valueOf(_velocityEngineConfiguration.directiveIfToStringNullCheck()));
            extendedProperties.setProperty("eventhandler.methodexception.class", LiferayMethodExceptionEventHandler.class.getName());
            extendedProperties.setProperty("resource.loader", "liferay");
            extendedProperties.setProperty("resource.manager.class", LiferayResourceManager.class.getName());
            extendedProperties.setProperty("runtime.log.logsystem.log4j.category", _velocityEngineConfiguration.loggerCategory());
            extendedProperties.setProperty("runtime.log.logsystem.class", _velocityEngineConfiguration.logger());
            extendedProperties.setProperty("velocimacro.library", this._getVelocimacroLibrary(VelocityManager.class));
            extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!this._velocityTemplateResourceCache.isEnabled()));
            extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!this._velocityTemplateResourceCache.isEnabled()));
            extendedProperties.setProperty(VelocityTemplateResourceLoader.class.getName(), (Object)this._velocityTemplateResourceLoader);
            extendedProperties.setProperty("liferay.introspector.restrict.classes.methods", _velocityEngineConfiguration.restrictedMethods());
            extendedProperties.setProperty(StringBundler.concat((String[])new String[]{"liferay.", "resource.loader", ".", VelocityTemplateResourceLoader.class.getName()}), (Object)this._velocityTemplateResourceLoader);
            extendedProperties.setProperty("liferay.resource.loader.cache", String.valueOf(this._velocityTemplateResourceCache.isEnabled()));
            extendedProperties.setProperty("liferay.resource.loader.class", LiferayResourceLoader.class.getName());
            extendedProperties.setProperty("liferay.resource.loaderportal.cache", this._velocityTemplateResourceCache.getSecondLevelPortalCache());
            this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
            this._velocityEngine.init();
        }
        catch (Exception exception) {
            throw new TemplateException((Throwable)exception);
        }
    }

    public class VelocityTemplateResourceCache
    extends BaseTemplateResourceCache {
        private final String _portalCacheName = VelocityTemplateResourceCache.class.getName();

        public VelocityTemplateResourceCache() {
            this.init(Long.MIN_VALUE, this._portalCacheName, StringBundler.concat((String[])new String[]{TemplateResource.class.getName(), "#", "vm"}));
        }

        public void destroy() {
            super.destroy();
        }
    }

    public class VelocityTemplateResourceLoader
    extends BaseTemplateResourceLoader {
        public VelocityTemplateResourceLoader(BundleContext bundleContext, TemplateResourceCache templateResourceCache) {
            this.init(bundleContext, "vm", templateResourceCache);
        }

        public void destroy() {
            super.destroy();
        }
    }
}

