/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.template.velocity.internal.FastExtendedProperties;
import com.liferay.portal.template.velocity.internal.LiferayResourceLoader;
import com.liferay.portal.template.velocity.internal.VelocityManager;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;

public class LiferayResourceManager
extends ResourceManagerImpl {
    private PortalCache<TemplateResource, Template> _portalCache;
    private TemplateResourceLoader _templateResourceLoader;

    public String getLoaderNameForResource(String source) {
        if (this.globalCache.get((Object)("2" + source)) != null || this.globalCache.get((Object)("1" + source)) != null) {
            return LiferayResourceLoader.class.getName();
        }
        return super.getLoaderNameForResource(source);
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws Exception, ParseErrorException, ResourceNotFoundException {
        if (resourceType != 1) {
            return super.getResource(resourceName, resourceType, encoding);
        }
        TemplateResource templateResource = null;
        templateResource = resourceName.startsWith("TEMPLATE_RESOURCE_UUID") ? TemplateResourceThreadLocal.getTemplateResource((String)"vm") : this._templateResourceLoader.getTemplateResource(resourceName);
        if (templateResource == null) {
            throw new ResourceNotFoundException("Unable to find Velocity template with ID " + resourceName);
        }
        Template template = null;
        if (this._portalCache != null && (template = (Template)this._portalCache.get((Serializable)templateResource)) != null) {
            return template;
        }
        template = this._createTemplate(templateResource);
        if (this._portalCache != null) {
            this._portalCache.put((Serializable)templateResource, (Object)template);
        }
        return template;
    }

    public synchronized void initialize(RuntimeServices runtimeServices) throws Exception {
        ExtendedProperties extendedProperties = runtimeServices.getConfiguration();
        Field field = ReflectionUtil.getDeclaredField(RuntimeInstance.class, (String)"configuration");
        field.set(runtimeServices, (Object)new FastExtendedProperties(extendedProperties));
        this._templateResourceLoader = (TemplateResourceLoader)extendedProperties.get((Object)VelocityManager.VelocityTemplateResourceLoader.class.getName());
        this._portalCache = (PortalCache)extendedProperties.get((Object)"liferay.resource.loaderportal.cache");
        if (this._portalCache != null) {
            this._portalCache.removeAll();
        }
        super.initialize(runtimeServices);
    }

    private Template _createTemplate(TemplateResource templateResource) throws IOException {
        LiferayTemplate template = new LiferayTemplate(templateResource);
        template.setEncoding("UTF-8");
        template.setName(templateResource.getTemplateId());
        template.setResourceLoader(new LiferayResourceLoader());
        template.setRuntimeServices(this.rsvc);
        template.process();
        return template;
    }

    private static class LiferayTemplate
    extends Template {
        private final TemplateResource _templateResource;

        public LiferayTemplate(TemplateResource templateResource) {
            this._templateResource = templateResource;
        }

        public boolean process() throws IOException, ParseErrorException {
            boolean bl;
            block8: {
                this.data = null;
                Reader reader = this._templateResource.getReader();
                try {
                    this.data = this.rsvc.parse(reader, this.name);
                    this.initDocument();
                    bl = true;
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        ParseErrorException parseErrorException = new ParseErrorException("Unable to parse Velocity template");
                        parseErrorException.addSuppressed((Throwable)exception);
                        throw parseErrorException;
                    }
                }
                reader.close();
            }
            return bl;
        }
    }
}

