/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.template.TemplateResourceParser;
import com.liferay.portal.template.URLResourceParser;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"lang.type=vm"}, service={TemplateResourceParser.class})
public class VelocityServletResourceParser
extends URLResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(VelocityServletResourceParser.class);
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, ServletContext> _serviceTrackerMap;

    public URL getURL(String source) throws IOException {
        URL url;
        ServletContext servletContext;
        int pos = source.indexOf("_SERVLET_CONTEXT_");
        if (pos == -1) {
            return null;
        }
        String servletContextName = source.substring(0, pos);
        if (servletContextName.equals(this._portal.getPathContext())) {
            servletContextName = this._portal.getServletContextName();
        }
        if ((servletContext = (ServletContext)this._serviceTrackerMap.getService((Object)servletContextName)) == null) {
            _log.error((Object)StringBundler.concat((String[])new String[]{source, " is not valid because ", servletContextName, " does not map to a servlet context"}));
            return null;
        }
        String name = source.substring(pos + "_SERVLET_CONTEXT_".length());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{name, " is associated with the servlet context ", servletContextName, " ", servletContext}));
        }
        if ((url = servletContext.getResource(name)) == null) {
            url = PortalWebResourcesUtil.getResource((String)name);
        }
        if (url == null && name.endsWith("/init_custom.vm")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("The template " + name + " should be created"));
            }
            ServletContext themeClassicServletContext = PortalWebResourcesUtil.getServletContext((String)"theme_classic");
            url = themeClassicServletContext.getResource("/classic/templates/init_custom.vm");
        }
        return url;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ServletContext.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, ServletContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void map(ServiceReference<ServletContext> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                try {
                    ServletContext servletContext = (ServletContext)bundleContext.getService(serviceReference);
                    String servletContextName = GetterUtil.getString((String)servletContext.getServletContextName());
                    emitter.emit((Object)servletContextName);
                }
                finally {
                    bundleContext.ungetService(serviceReference);
                }
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

