/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration;
import com.liferay.portal.template.velocity.internal.FastExtendedProperties;
import com.liferay.portal.template.velocity.internal.LiferayMethodExceptionEventHandler;
import com.liferay.portal.template.velocity.internal.LiferayResourceLoader;
import com.liferay.portal.template.velocity.internal.LiferayResourceManager;
import com.liferay.portal.template.velocity.internal.LiferaySecureUberspector;
import com.liferay.portal.template.velocity.internal.VelocityParserPool;
import com.liferay.portal.template.velocity.internal.VelocityTemplate;
import com.liferay.portal.template.velocity.internal.VelocityTemplateContextHelper;
import com.liferay.portal.template.velocity.internal.VelocityTemplateResourceCache;
import com.liferay.portal.template.velocity.internal.VelocityTemplateResourceLoader;
import com.liferay.taglib.util.VelocityTaglibImpl;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.VelocityEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration"}, immediate=true, property={"language.type=vm"}, service={TemplateManager.class})
public class VelocityManager
extends BaseTemplateManager {
    private static volatile VelocityEngineConfiguration _velocityEngineConfiguration;
    private VelocityEngine _velocityEngine;
    @Reference
    private VelocityTemplateResourceCache _velocityTemplateResourceCache;

    @Deprecated
    public void addTaglibSupport(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(httpServletRequest.getServletContext(), httpServletRequest, httpServletResponse, contextObjects);
        contextObjects.put("taglibLiferay", velocityTaglib);
        contextObjects.put("theme", velocityTaglib);
    }

    public void destroy() {
        if (this._velocityEngine == null) {
            return;
        }
        this._velocityEngine = null;
        this.templateContextHelper.removeAllHelperUtilities();
    }

    public void destroy(ClassLoader classLoader) {
        this.templateContextHelper.removeHelperUtilities(classLoader);
    }

    public String getName() {
        return "vm";
    }

    public String[] getRestrictedVariables() {
        return _velocityEngineConfiguration.restrictedVariables();
    }

    public void init() throws TemplateException {
        if (this._velocityEngine != null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        currentThread.setContextClassLoader(clazz.getClassLoader());
        try {
            this._velocityEngine = new VelocityEngine();
            FastExtendedProperties extendedProperties = new FastExtendedProperties();
            extendedProperties.setProperty("directive.if.tostring.nullcheck", String.valueOf(_velocityEngineConfiguration.directiveIfToStringNullCheck()));
            extendedProperties.setProperty("eventhandler.methodexception.class", LiferayMethodExceptionEventHandler.class.getName());
            extendedProperties.setProperty("introspector.restrict.classes", StringUtil.merge((Object[])_velocityEngineConfiguration.restrictedClasses()));
            extendedProperties.setProperty("liferay.introspector.restrict.classes.methods", _velocityEngineConfiguration.restrictedMethods());
            extendedProperties.setProperty("introspector.restrict.packages", StringUtil.merge((Object[])_velocityEngineConfiguration.restrictedPackages()));
            extendedProperties.setProperty("parser.pool.class", VelocityParserPool.class.getName());
            extendedProperties.setProperty("resource.loader", "liferay");
            extendedProperties.setProperty(StringBundler.concat((String[])new String[]{"liferay.", "resource.loader", ".", VelocityTemplateResourceLoader.class.getName()}), this.templateResourceLoader);
            boolean cacheEnabled = false;
            if (this._velocityTemplateResourceCache.isEnabled()) {
                cacheEnabled = true;
            }
            extendedProperties.setProperty("liferay.resource.loader.cache", String.valueOf(cacheEnabled));
            extendedProperties.setProperty("liferay.resource.loader.class", LiferayResourceLoader.class.getName());
            extendedProperties.setProperty("liferay.resource.loaderportal.cache", this._velocityTemplateResourceCache.getSecondLevelPortalCache());
            extendedProperties.setProperty("resource.manager.class", LiferayResourceManager.class.getName());
            int resourceModificationCheckInterval = _velocityEngineConfiguration.resourceModificationCheckInterval();
            extendedProperties.setProperty("liferay.resource.manager.class.resourceModificationCheckInterval", resourceModificationCheckInterval + "");
            extendedProperties.setProperty(VelocityTemplateResourceLoader.class.getName(), this.templateResourceLoader);
            extendedProperties.setProperty("runtime.log.logsystem.class", _velocityEngineConfiguration.logger());
            extendedProperties.setProperty("runtime.log.logsystem.log4j.category", _velocityEngineConfiguration.loggerCategory());
            extendedProperties.setProperty("runtime.introspector.uberspect", LiferaySecureUberspector.class.getName());
            extendedProperties.setProperty("velocimacro.library", this._getVelocimacroLibrary(clazz));
            extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!cacheEnabled));
            extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!cacheEnabled));
            this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
            this._velocityEngine.init();
        }
        catch (Exception exception) {
            throw new TemplateException((Throwable)exception);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    @Reference(service=VelocityTemplateContextHelper.class, unbind="-")
    public void setTemplateContextHelper(TemplateContextHelper templateContextHelper) {
        super.setTemplateContextHelper(templateContextHelper);
    }

    @Reference(service=VelocityTemplateResourceLoader.class, unbind="-")
    public void setTemplateResourceLoader(TemplateResourceLoader templateResourceLoader) {
        super.setTemplateResourceLoader(templateResourceLoader);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
    }

    protected Template doGetTemplate(TemplateResource templateResource, boolean restricted, Map<String, Object> helperUtilities) {
        return new VelocityTemplate(templateResource, helperUtilities, this._velocityEngine, this.templateContextHelper, (TemplateResourceCache)this._velocityTemplateResourceCache, restricted);
    }

    private String _getVelocimacroLibrary(Class<?> clazz) {
        String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
        contextName = contextName.concat("_CLASS_LOADER_CONTEXT_");
        String[] velocimacroLibrary = _velocityEngineConfiguration.velocimacroLibrary();
        StringBundler sb = new StringBundler(3 * velocimacroLibrary.length);
        for (String library : velocimacroLibrary) {
            sb.append(contextName);
            sb.append(library);
            sb.append(",");
        }
        if (velocimacroLibrary.length > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

