/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.velocity.internal.RestrictedTemplateThreadLocal;
import com.liferay.portal.util.PortalImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.introspection.SecureIntrospectorImpl;
import org.apache.velocity.util.introspection.SecureUberspector;

public class LiferaySecureUberspector
extends SecureUberspector {
    private static final ClassRestrictionInformation _nullInstance = new ClassRestrictionInformation(null);
    private final Map<String, ClassRestrictionInformation> _classRestrictionInformations = new ConcurrentHashMap<String, ClassRestrictionInformation>();
    private List<Class<?>> _restrictedClasses;
    private Map<String, Set<String>> _restrictedMethodNames;
    private List<String> _restrictedPackageNames;
    private RuntimeServices _runtimeServices;

    public void init() {
        super.init();
        ExtendedProperties extendedProperties = this._runtimeServices.getConfiguration();
        String[] restrictedClassNames = extendedProperties.getStringArray("introspector.restrict.classes");
        this._restrictedClasses = new ArrayList(restrictedClassNames.length);
        AggregateClassLoader aggregateClassLoader = new AggregateClassLoader(LiferaySecureUberspector.class.getClassLoader());
        aggregateClassLoader.addClassLoader(PortalImpl.class.getClassLoader());
        Thread thread = Thread.currentThread();
        if (thread.getContextClassLoader() != null) {
            aggregateClassLoader.addClassLoader(thread.getContextClassLoader());
        }
        for (String restrictedClassName : restrictedClassNames) {
            if (Validator.isBlank((String)(restrictedClassName = StringUtil.trim((String)restrictedClassName)))) continue;
            try {
                this._restrictedClasses.add(aggregateClassLoader.loadClass(restrictedClassName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error((Object)("Unable to find restricted class " + restrictedClassName), (Throwable)classNotFoundException);
            }
        }
        String[] restrictedMethodNames = (String[])extendedProperties.get((Object)"liferay.introspector.restrict.classes.methods");
        if (restrictedMethodNames == null) {
            this._restrictedMethodNames = Collections.emptyMap();
        } else {
            this._restrictedMethodNames = new HashMap<String, Set<String>>();
            for (String restrictedMethodName : restrictedMethodNames) {
                int index = restrictedMethodName.indexOf(35);
                if (index < 0) {
                    this.log.error((Object)StringBundler.concat((String[])new String[]{"\"", restrictedMethodName, "\" does not match format ", "\"className#methodName\""}));
                    continue;
                }
                String className = StringUtil.trim((String)restrictedMethodName.substring(0, index));
                String methodName = StringUtil.trim((String)restrictedMethodName.substring(index + 1));
                Set methodNames = this._restrictedMethodNames.computeIfAbsent(className, key -> new HashSet());
                methodNames.add(StringUtil.toLowerCase((String)methodName));
            }
        }
        String[] restrictedPackageNames = extendedProperties.getStringArray("introspector.restrict.packages");
        if (restrictedPackageNames != null) {
            this._restrictedPackageNames = new ArrayList<String>(restrictedPackageNames.length);
            for (String restrictedPackageName : restrictedPackageNames) {
                if (Validator.isBlank((String)(restrictedPackageName = StringUtil.trim((String)restrictedPackageName)))) continue;
                this._restrictedPackageNames.add(restrictedPackageName);
            }
        }
        this.introspector = new LiferaySecureIntrospectorImpl();
    }

    public void setRuntimeServices(RuntimeServices runtimeServices) {
        super.setRuntimeServices(runtimeServices);
        this._runtimeServices = runtimeServices;
    }

    private void _checkClassIsRestricted(Class<?> clazz) {
        ClassRestrictionInformation classRestrictionInformation = this._classRestrictionInformations.computeIfAbsent(clazz.getName(), className -> {
            for (Class<?> restrictedClass : this._restrictedClasses) {
                if (!restrictedClass.isAssignableFrom(clazz)) continue;
                return new ClassRestrictionInformation(StringBundler.concat((String[])new String[]{"Denied resolving class ", className, " by ", restrictedClass.getName()}));
            }
            Package pkg = clazz.getPackage();
            if (pkg == null) {
                return _nullInstance;
            }
            String packageName = pkg.getName();
            packageName = packageName.concat(".");
            for (String restrictedPackageName : this._restrictedPackageNames) {
                if (!packageName.startsWith(restrictedPackageName)) continue;
                return new ClassRestrictionInformation(StringBundler.concat((String[])new String[]{"Denied resolving class ", className, " by ", restrictedPackageName}));
            }
            return _nullInstance;
        });
        if (classRestrictionInformation.isRestricted()) {
            throw new IllegalArgumentException(classRestrictionInformation.getDescription());
        }
    }

    private void _checkMethodIsRestricted(Class clazz, String methodName) {
        Set<String> methodNames;
        String className = clazz.getName();
        if (this._restrictedMethodNames.containsKey(className) && (methodNames = this._restrictedMethodNames.get(className)).contains(StringUtil.toLowerCase((String)methodName))) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Denied access to method ", methodName, " of ", clazz.getName()}));
        }
    }

    private class LiferaySecureIntrospectorImpl
    extends SecureIntrospectorImpl {
        public boolean checkObjectExecutePermission(Class clazz, String methodName) {
            if (methodName != null && (methodName.equals("wait") || methodName.equals("notify"))) {
                throw new IllegalArgumentException("Executing method " + methodName + " is not allowed");
            }
            if (RestrictedTemplateThreadLocal.isRestricted()) {
                LiferaySecureUberspector.this._checkClassIsRestricted(clazz);
                LiferaySecureUberspector.this._checkMethodIsRestricted(clazz, methodName);
            }
            return true;
        }

        private LiferaySecureIntrospectorImpl() {
            super(new String[0], new String[0], LiferaySecureUberspector.this.log);
        }
    }

    private static class ClassRestrictionInformation {
        private final String _description;

        public String getDescription() {
            return this._description;
        }

        public boolean isRestricted() {
            return this._description != null;
        }

        private ClassRestrictionInformation(String description) {
            this._description = description;
        }
    }
}

