/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.IteratorTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration"}, immediate=true, service={TemplateContextHelper.class, VelocityTemplateContextHelper.class})
public class VelocityTemplateContextHelper
extends TemplateContextHelper {
    private static final Log _log = LogFactoryUtil.getLog(VelocityTemplateContextHelper.class);
    private static volatile VelocityEngineConfiguration _velocityEngineConfiguration;
    private final List<TemplateContextContributor> _templateContextContributors = new ArrayList<TemplateContextContributor>();

    public Set<String> getRestrictedVariables() {
        return SetUtil.fromArray((Object[])_velocityEngineConfiguration.restrictedVariables());
    }

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest request) {
        super.prepare(contextObjects, request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            Theme theme = themeDisplay.getTheme();
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            contextObjects.put("fullCssPath", servletContextName + theme.getVelocityResourceListener() + theme.getCssPath());
            String fullTemplatesPath = servletContextName + theme.getVelocityResourceListener() + theme.getTemplatesPath();
            contextObjects.put("fullTemplatesPath", fullTemplatesPath);
            contextObjects.put("init", fullTemplatesPath + "/init.vm");
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Map vmVariables = (Map)request.getAttribute("VM_VARIABLES" + portletDisplay.getId());
        if (vmVariables != null) {
            for (Map.Entry entry : vmVariables.entrySet()) {
                String key = (String)entry.getKey();
                if (!Validator.isNotNull((String)key)) continue;
                contextObjects.put(key, entry.getValue());
            }
        }
        for (TemplateContextContributor templateContextContributor : this._templateContextContributors) {
            templateContextContributor.prepare(contextObjects, request);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
    }

    protected void populateExtraHelperUtilities(Map<String, Object> velocityContext, boolean restrict) {
        velocityContext.put("dateTool", new DateTool());
        velocityContext.put("escapeTool", new EscapeTool());
        velocityContext.put("iteratorTool", new IteratorTool());
        velocityContext.put("listTool", new ListTool());
        velocityContext.put("mathTool", new MathTool());
        velocityContext.put("numberTool", new NumberTool());
        velocityContext.put("velocityPortletPreferences", new TemplatePortletPreferences());
        velocityContext.put("sortTool", new SortTool());
        try {
            velocityContext.put("rolePermission", RolePermissionUtil.getRolePermission());
        }
        catch (SecurityException se) {
            _log.error((Object)se, (Throwable)se);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(type=GLOBAL)")
    protected synchronized void registerTemplateContextContributor(TemplateContextContributor templateContextContributor) {
        this._templateContextContributors.add(templateContextContributor);
    }

    protected synchronized void unregisterTemplateContextContributor(TemplateContextContributor templateContextContributor) {
        this._templateContextContributors.remove(templateContextContributor);
    }
}

