/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.template.AbstractSingleResourceTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.template.velocity.internal.RestrictedTemplateThreadLocal;
import com.liferay.taglib.util.VelocityTaglibImpl;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;

public class VelocityTemplate
extends AbstractSingleResourceTemplate {
    private final boolean _restricted;
    private final VelocityContext _velocityContext;
    private final VelocityEngine _velocityEngine;

    public VelocityTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, Map<String, Object> context, VelocityEngine velocityEngine, TemplateContextHelper templateContextHelper, boolean restricted, TemplateResourceCache templateResourceCache) {
        super(templateResource, errorTemplateResource, context, templateContextHelper, restricted, templateResourceCache);
        this._velocityEngine = velocityEngine;
        this._restricted = restricted;
        this._velocityContext = new VelocityContext(this.context);
    }

    public void prepareTaglib(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(httpServletRequest.getServletContext(), httpServletRequest, httpServletResponse, this.context);
        this.context.put("taglibLiferay", velocityTaglib);
        this.context.put("theme", velocityTaglib);
    }

    protected void handleException(Exception exception, Writer writer) throws TemplateException {
        this.put("exception", exception.getMessage());
        if (this.templateResource instanceof StringTemplateResource) {
            StringTemplateResource stringTemplateResource = (StringTemplateResource)this.templateResource;
            this.put("script", stringTemplateResource.getContent());
        }
        if (exception instanceof ParseErrorException) {
            ParseErrorException pee = (ParseErrorException)exception;
            this.put("column", pee.getColumnNumber());
            this.put("line", pee.getLineNumber());
        }
        try {
            this.processTemplate(this.errorTemplateResource, writer);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process Velocity template " + this.errorTemplateResource.getTemplateId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource((String)"vm", (TemplateResource)templateResource);
        if (this._restricted) {
            RestrictedTemplateThreadLocal.setRestricted(true);
        }
        try {
            Template template = this._velocityEngine.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
            template.merge((Context)this._velocityContext, writer);
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource((String)"vm", null);
            if (this._restricted) {
                RestrictedTemplateThreadLocal.setRestricted(false);
            }
        }
    }
}

