/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal.helper;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration;
import com.liferay.portal.template.freemarker.internal.LiferayObjectConstructor;
import freemarker.ext.beans.BeansWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration"}, service={TemplateContextHelper.class})
public class FreeMarkerTemplateContextHelper
extends TemplateContextHelper {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerTemplateContextHelper.class);
    private BeansWrapper _defaultBeansWrapper;
    private volatile FreeMarkerEngineConfiguration _freeMarkerEngineConfiguration;
    private BeansWrapper _restrictedBeansWrapper;
    private volatile Set<String> _restrictedVariables;

    public Set<String> getRestrictedVariables() {
        return this._restrictedVariables;
    }

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest) {
        Map ftlVariables;
        super.prepare(contextObjects, httpServletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            Theme theme = themeDisplay.getTheme();
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            contextObjects.put("fullCssPath", StringBundler.concat((String[])new String[]{"/", servletContextName, theme.getFreeMarkerTemplateLoader(), theme.getCssPath()}));
            String fullTemplatesPath = StringBundler.concat((String[])new String[]{"/", servletContextName, theme.getFreeMarkerTemplateLoader(), theme.getTemplatesPath()});
            contextObjects.put("fullTemplatesPath", fullTemplatesPath);
            contextObjects.put("init", fullTemplatesPath + "/init.ftl");
            if (this._freeMarkerEngineConfiguration.includeNavItemsInTheContext() && themeDisplay.getLayout() != null) {
                try {
                    contextObjects.put("navItems", themeDisplay.getNavItems());
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        if ((ftlVariables = (Map)httpServletRequest.getAttribute("FTL_VARIABLES")) != null) {
            for (Map.Entry entry : ftlVariables.entrySet()) {
                String key = (String)entry.getKey();
                if (!Validator.isNotNull((String)key)) continue;
                contextObjects.put(key, entry.getValue());
            }
        }
        for (TemplateContextContributor templateContextContributor : this.getTemplateContextContributors()) {
            templateContextContributor.prepare(contextObjects, httpServletRequest);
        }
    }

    public void setDefaultBeansWrapper(BeansWrapper defaultBeansWrapper) {
        this._defaultBeansWrapper = defaultBeansWrapper;
    }

    public void setRestrictedBeansWrapper(BeansWrapper restrictedBeansWrapper) {
        this._restrictedBeansWrapper = restrictedBeansWrapper;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties, BundleContext bundleContext) {
        this.init(bundleContext);
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, properties);
        this._restrictedVariables = SetUtil.fromArray((Object[])this._freeMarkerEngineConfiguration.restrictedVariables());
    }

    @Deactivate
    protected void deactivate() {
        this.destory();
    }

    protected void populateExtraHelperUtilities(Map<String, Object> helperUtilities, boolean restricted) {
        BeansWrapper beansWrapper = this._defaultBeansWrapper;
        if (restricted) {
            beansWrapper = this._restrictedBeansWrapper;
        }
        helperUtilities.put("enumUtil", beansWrapper.getEnumModels());
        helperUtilities.put("objectUtil", new LiferayObjectConstructor(beansWrapper));
        helperUtilities.put("freeMarkerPortletPreferences", new TemplatePortletPreferences());
        helperUtilities.put("staticUtil", beansWrapper.getStaticModels());
    }
}

