/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration;
import freemarker.core.Environment;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.utility.Execute;
import freemarker.template.utility.ObjectConstructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration"}, service={TemplateClassResolver.class})
public class LiferayTemplateClassResolver
implements TemplateClassResolver {
    private static final Log _log = LogFactoryUtil.getLog(LiferayTemplateClassResolver.class);
    private final Set<Bundle> _bundles = Collections.newSetFromMap(new ConcurrentHashMap());
    private BundleTracker<ClassLoader> _classLoaderBundleTracker;
    private volatile FreeMarkerEngineConfiguration _freeMarkerEngineConfiguration;
    private final Set<ClassLoader> _whitelistedClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public Class<?> resolve(String className, Environment environment, Template template) throws TemplateException {
        String[] allowedClasseNames;
        String[] restrictedClassNames;
        if (className.equals(Execute.class.getName()) || className.equals(ObjectConstructor.class.getName())) {
            throw new TemplateException(StringBundler.concat((String[])new String[]{"Instantiating ", className, " is not allowed in the ", "template for security reasons"}), environment);
        }
        for (String restrictedClassName : restrictedClassNames = GetterUtil.getStringValues((String[])this._freeMarkerEngineConfiguration.restrictedClasses())) {
            if (!this.match(restrictedClassName, className)) continue;
            throw new TemplateException(StringBundler.concat((String[])new String[]{"Instantiating ", className, " is not allowed in the ", "template for security reasons"}), environment);
        }
        boolean allowed = false;
        for (String allowedClassName : allowedClasseNames = GetterUtil.getStringValues((String[])this._freeMarkerEngineConfiguration.allowedClasses())) {
            if (!this.match(allowedClassName, className)) continue;
            allowed = true;
            break;
        }
        if (allowed) {
            try {
                Object[] wwhitelistedClassLoaders = this._whitelistedClassLoaders.toArray(new ClassLoader[0]);
                Thread currentThread = Thread.currentThread();
                ClassLoader[] classLoaders = (ClassLoader[])ArrayUtil.append((Object[])wwhitelistedClassLoaders, (Object)currentThread.getContextClassLoader());
                ClassLoader wwhitelistedAggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])classLoaders);
                return Class.forName(className, true, wwhitelistedAggregateClassLoader);
            }
            catch (Exception exception) {
                throw new TemplateException(exception, environment);
            }
        }
        throw new TemplateException(StringBundler.concat((String[])new String[]{"Instantiating ", className, " is not allowed in the template ", "for security reasons"}), environment);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, properties);
        this._classLoaderBundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new ClassLoaderBundleTrackerCustomizer());
        this._classLoaderBundleTracker.open();
        this._whitelistedClassLoaders.add(LiferayTemplateClassResolver.class.getClassLoader());
    }

    @Deactivate
    protected void deactivate() {
        this._classLoaderBundleTracker.close();
    }

    protected boolean match(String className, String matchedClassName) {
        if (className.equals("*")) {
            return true;
        }
        if (className.endsWith("*")) {
            if (matchedClassName.regionMatches(0, className, 0, className.length() - 1)) {
                return true;
            }
        } else {
            if (className.equals(matchedClassName)) {
                return true;
            }
            int index = className.lastIndexOf(46);
            if (className.length() == index && className.regionMatches(0, matchedClassName, 0, index)) {
                return true;
            }
        }
        return false;
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, properties);
        for (Bundle bundle : this._bundles) {
            ClassLoader classLoader = this._findClassLoader(this._freeMarkerEngineConfiguration.allowedClasses(), bundle.getBundleContext());
            if (classLoader == null) continue;
            this._whitelistedClassLoaders.add(classLoader);
        }
    }

    private ClassLoader _findClassLoader(String clazz, BundleContext bundleContext) {
        Bundle bundle = bundleContext.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List bundleCapabilities = bundleWiring.getCapabilities("osgi.wiring.package");
        for (BundleCapability bundleCapability : bundleCapabilities) {
            Map attributes = bundleCapability.getAttributes();
            String packageName = (String)attributes.get("osgi.wiring.package");
            if (clazz.endsWith("*")) {
                if (!packageName.regionMatches(0, clazz, 0, clazz.length() - 1)) continue;
                BundleRevision bundleRevision = bundleCapability.getRevision();
                Bundle bundleRevisionBundle = bundleRevision.getBundle();
                BundleWiring bundleRevisionBundleWiring = (BundleWiring)bundleRevisionBundle.adapt(BundleWiring.class);
                return bundleRevisionBundleWiring.getClassLoader();
            }
            if (clazz.equals(packageName)) {
                BundleRevision bundleRevision = bundleCapability.getRevision();
                Bundle bundleRevisionBundle = bundleRevision.getBundle();
                BundleWiring bundleRevisionBundleWiring = (BundleWiring)bundleRevisionBundle.adapt(BundleWiring.class);
                return bundleRevisionBundleWiring.getClassLoader();
            }
            int index = clazz.lastIndexOf(46);
            if (packageName.length() != index || !packageName.regionMatches(0, clazz, 0, index)) continue;
            BundleRevision bundleRevision = bundleCapability.getRevision();
            Bundle bundleRevisionBundle = bundleRevision.getBundle();
            BundleWiring bundleRevisionBundleWiring = (BundleWiring)bundleRevisionBundle.adapt(BundleWiring.class);
            return bundleRevisionBundleWiring.getClassLoader();
        }
        return null;
    }

    private ClassLoader _findClassLoader(String[] allowedClassNames, BundleContext bundleContext) {
        if (allowedClassNames == null) {
            allowedClassNames = new String[]{};
        }
        for (String allowedClassName : allowedClassNames) {
            if (Validator.isBlank((String)allowedClassName) || allowedClassName.equals("*")) continue;
            ClassLoader classLoader = this._findClassLoader(allowedClassName, bundleContext);
            if (classLoader != null) {
                return classLoader;
            }
            if (!_log.isWarnEnabled()) continue;
            Bundle bundle = bundleContext.getBundle();
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Bundle ", bundle.getSymbolicName(), " does not export ", allowedClassName}));
        }
        return null;
    }

    private class ClassLoaderBundleTrackerCustomizer
    implements BundleTrackerCustomizer<ClassLoader> {
        private ClassLoaderBundleTrackerCustomizer() {
        }

        public ClassLoader addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            ClassLoader classLoader = LiferayTemplateClassResolver.this._findClassLoader(LiferayTemplateClassResolver.this._freeMarkerEngineConfiguration.allowedClasses(), bundle.getBundleContext());
            if (classLoader != null) {
                LiferayTemplateClassResolver.this._whitelistedClassLoaders.add(classLoader);
            }
            LiferayTemplateClassResolver.this._bundles.add(bundle);
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            return bundleWiring.getClassLoader();
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ClassLoader classLoader) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ClassLoader classLoader) {
            LiferayTemplateClassResolver.this._whitelistedClassLoaders.remove(classLoader);
            LiferayTemplateClassResolver.this._bundles.remove(bundle);
        }
    }
}

