/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import freemarker.cache.TemplateCache;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Locale;

public class LiferayTemplateCache
extends TemplateCache {
    private static final Log _log = LogFactoryUtil.getLog(LiferayTemplateCache.class);
    private final Configuration _configuration;
    private final Constructor<TemplateCache.MaybeMissingTemplate> _constructor;
    private final PortalCache<TemplateResource, TemplateCache.MaybeMissingTemplate> _portalCache;
    private final TemplateResourceLoader _templateResourceLoader;

    public LiferayTemplateCache(Configuration configuration, TemplateResourceLoader templateResourceLoader, PortalCache<TemplateResource, TemplateCache.MaybeMissingTemplate> portalCache) throws Exception {
        super(null, configuration);
        this._configuration = configuration;
        this._templateResourceLoader = templateResourceLoader;
        this._portalCache = portalCache;
        this._constructor = TemplateCache.MaybeMissingTemplate.class.getDeclaredConstructor(Template.class);
        this._constructor.setAccessible(true);
    }

    @Override
    public TemplateCache.MaybeMissingTemplate getTemplate(String templateId, Locale locale, Object customLookupCondition, String encoding, boolean parse) throws IOException {
        if (templateId == null) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument \"encoding\" is null");
        }
        TemplateResource templateResource = null;
        if (templateId.startsWith("TEMPLATE_RESOURCE_UUID")) {
            templateResource = TemplateResourceThreadLocal.getTemplateResource((String)"ftl");
        } else {
            try {
                templateResource = this._templateResourceLoader.getTemplateResource(templateId);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                templateResource = null;
            }
        }
        if (templateResource == null) {
            throw new IOException("Unable to find FreeMarker template with ID " + templateId);
        }
        TemplateCache.MaybeMissingTemplate maybeMissingTemplate = null;
        if (this._portalCache != null && (maybeMissingTemplate = (TemplateCache.MaybeMissingTemplate)this._portalCache.get((Serializable)templateResource)) != null) {
            return maybeMissingTemplate;
        }
        Template template = new Template(templateResource.getTemplateId(), templateResource.getReader(), this._configuration);
        try {
            maybeMissingTemplate = this._constructor.newInstance(template);
            if (this._portalCache != null) {
                this._portalCache.put((Serializable)templateResource, (Object)maybeMissingTemplate);
            }
            return maybeMissingTemplate;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IOException(reflectiveOperationException);
        }
    }
}

