/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.function.UnsafeSupplierValue;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.template.engine.BaseTemplate;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.freemarker.internal.FreeMarkerManager;
import freemarker.core.ParseException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelWithAPISupport;
import freemarker.template.WrappingTemplateModel;
import freemarker.template.utility.ObjectWrapperWithAPISupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class FreeMarkerTemplate
extends BaseTemplate {
    private static final TemplateModel _NULL_TEMPLATE_MODEL = new TemplateModel(){};
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerTemplate.class);
    private final BeansWrapper _beansWrapper;
    private final Configuration _configuration;
    private final FreeMarkerManager _freeMarkerManager;
    private final TemplateResourceCache _templateResourceCache;

    public FreeMarkerTemplate(TemplateResource templateResource, Map<String, Object> context, Configuration configuration, TemplateContextHelper templateContextHelper, TemplateResourceCache templateResourceCache, boolean restricted, BeansWrapper beansWrapper, FreeMarkerManager freeMarkerManager) {
        super(templateResource, context, templateContextHelper, restricted);
        this._configuration = configuration;
        this._templateResourceCache = templateResourceCache;
        this._beansWrapper = beansWrapper;
        this._freeMarkerManager = freeMarkerManager;
        if (templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(templateResourceCache, templateResource);
        }
    }

    public void prepareTaglib(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this._freeMarkerManager.addTaglibSupport(this.context, httpServletRequest, httpServletResponse, this._beansWrapper);
    }

    protected void handleException(TemplateResource templateResource, TemplateResource errorTemplateResource, Exception exception1, Writer writer) throws com.liferay.portal.kernel.template.TemplateException {
        if (this._templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(this._templateResourceCache, errorTemplateResource);
        }
        if (exception1 instanceof TemplateException || exception1 instanceof ParseException) {
            this.put("exception", exception1.getMessage());
            if (templateResource instanceof StringTemplateResource) {
                StringTemplateResource stringTemplateResource = (StringTemplateResource)templateResource;
                this.put("script", stringTemplateResource.getContent());
            }
            if (exception1 instanceof ParseException) {
                ParseException parseException = (ParseException)exception1;
                this.put("column", parseException.getColumnNumber());
                this.put("line", parseException.getLineNumber());
            }
            try {
                this.processTemplate(errorTemplateResource, writer);
            }
            catch (Exception exception2) {
                throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + errorTemplateResource.getTemplateId(), (Throwable)exception2);
            }
        } else {
            throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + templateResource.getTemplateId(), (Throwable)exception1);
        }
    }

    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        this._freeMarkerManager.render(templateResource.getTemplateId(), writer, this.isRestricted(), () -> {
            TemplateResourceThreadLocal.setTemplateResource((String)"ftl", (TemplateResource)templateResource);
            try {
                Template template = this._configuration.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
                template.setObjectWrapper(this._beansWrapper);
                template.process(new CachableDefaultMapAdapter(this.context, this._beansWrapper), writer);
            }
            finally {
                TemplateResourceThreadLocal.setTemplateResource((String)"ftl", null);
            }
            return null;
        });
    }

    protected Object putClass(String key, Class<?> clazz) {
        try {
            TemplateHashModel templateHashModel = this._beansWrapper.getStaticModels();
            return this.context.put(key, templateHashModel.get(clazz.getName()));
        }
        catch (TemplateModelException templateModelException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Variable " + key + " registration fail"), (Throwable)templateModelException);
            }
            return null;
        }
    }

    private class CachableDefaultMapAdapter
    extends WrappingTemplateModel
    implements AdapterTemplateModel,
    Serializable,
    TemplateHashModelEx,
    TemplateModelWithAPISupport,
    WrapperTemplateModel {
        private final Map<String, Object> _map;
        private final ObjectWrapper _objectWrapper;
        private final Map<String, TemplateModel> _wrappedValueMap;

        @Override
        public TemplateModel get(String key) throws TemplateModelException {
            TemplateModel templateModel = this._wrappedValueMap.get(key);
            if (templateModel == _NULL_TEMPLATE_MODEL) {
                return null;
            }
            if (templateModel != null) {
                return templateModel;
            }
            Object value = this._map.get(key);
            if (value instanceof UnsafeSupplierValue) {
                UnsafeSupplierValue unsafeSupplierValue = (UnsafeSupplierValue)value;
                value = unsafeSupplierValue.getValue();
            }
            if (value == null) {
                this._wrappedValueMap.put(key, _NULL_TEMPLATE_MODEL);
                return null;
            }
            templateModel = this._objectWrapper.wrap(value);
            this._wrappedValueMap.put(key, templateModel);
            return templateModel;
        }

        public Object getAdaptedObject(Class hint) {
            return this._map;
        }

        @Override
        public TemplateModel getAPI() throws TemplateModelException {
            ObjectWrapperWithAPISupport objectWrapperWithAPISupport = (ObjectWrapperWithAPISupport)this._objectWrapper;
            return objectWrapperWithAPISupport.wrapAsAPI(this._map);
        }

        @Override
        public Object getWrappedObject() {
            return this._map;
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public TemplateCollectionModel keys() {
            return new SimpleCollection(this._map.keySet(), this._objectWrapper);
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public TemplateCollectionModel values() {
            return new SimpleCollection(this._map.values(), this._objectWrapper);
        }

        private CachableDefaultMapAdapter(Map<String, Object> map, ObjectWrapper objectWrapper) {
            super(objectWrapper);
            this._wrappedValueMap = new HashMap<String, TemplateModel>();
            this._map = map;
            this._objectWrapper = objectWrapper;
        }
    }
}

