/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.Logger;
import freemarker.log.LoggerFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class _Log4jLoggerFactory
implements LoggerFactory {
    @Override
    public Logger getLogger(String name) {
        return new Log4jLogger(LogManager.getLogger((String)name));
    }

    private static class Log4jLogger
    extends Logger {
        private final org.apache.logging.log4j.core.Logger logger;
        private static final String _FQCN = Log4jLogger.class.getName();

        Log4jLogger(org.apache.logging.log4j.Logger logger) {
            this.logger = (org.apache.logging.log4j.core.Logger)logger;
        }

        @Override
        public void debug(String message) {
            this.logger.logIfEnabled(_FQCN, Level.DEBUG, null, (Object)message, null);
        }

        @Override
        public void debug(String message, Throwable t) {
            this.logger.logIfEnabled(_FQCN, Level.DEBUG, null, (Object)message, t);
        }

        @Override
        public void error(String message) {
            this.logger.logIfEnabled(_FQCN, Level.ERROR, null, (Object)message, null);
        }

        @Override
        public void error(String message, Throwable t) {
            this.logger.logIfEnabled(_FQCN, Level.ERROR, null, (Object)message, t);
        }

        @Override
        public void info(String message) {
            this.logger.logIfEnabled(_FQCN, Level.INFO, null, (Object)message, null);
        }

        @Override
        public void info(String message, Throwable t) {
            this.logger.logIfEnabled(_FQCN, Level.INFO, null, (Object)message, t);
        }

        @Override
        public void warn(String message) {
            this.logger.logIfEnabled(_FQCN, Level.WARN, null, (Object)message, null);
        }

        @Override
        public void warn(String message, Throwable t) {
            this.logger.logIfEnabled(_FQCN, Level.WARN, null, (Object)message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isFatalEnabled() {
            return this.logger.isFatalEnabled();
        }
    }
}

