/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.template.freemarker.internal.LiferayFreeMarkerStringModel;
import com.liferay.portal.template.freemarker.internal.LiferayObjectWrapper;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.util.PropsValues;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RestrictedLiferayObjectWrapper
extends LiferayObjectWrapper {
    private static final ModelFactory _RESTRICTED_STRING_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new LiferayFreeMarkerStringModel(object, (BeansWrapper)objectWrapper);
        }
    };
    private static final ModelFactory _SERVICE_PROXY_STRING_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            Class<?> clazz = object.getClass();
            return new StringModel(ProxyUtil.newProxyInstance((ClassLoader)clazz.getClassLoader(), (Class[])clazz.getInterfaces(), (proxy, method, args) -> TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> method.invoke(object, args))), (BeansWrapper)objectWrapper);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(RestrictedLiferayObjectWrapper.class);
    private static final TransactionConfig _transactionConfig;
    private final boolean _allowAllClasses;
    private final List<String> _allowedClassNames;
    private final Set<String> _deniedAccessToStringClasses;
    private final List<Class<?>> _restrictedClasses;
    private final Map<String, Boolean> _restrictedClassMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Set<String>> _restrictedMethodNames;
    private final List<String> _restrictedPackageNames;
    private final Set<String> _serviceProxyClassNames = Collections.newSetFromMap(new ConcurrentHashMap());

    public RestrictedLiferayObjectWrapper(String[] allowedClassNames, String[] restrictedClassNames, String[] restrictedMethodNames) {
        if (allowedClassNames == null) {
            this._allowedClassNames = Collections.emptyList();
        } else {
            this._allowedClassNames = new ArrayList<String>(allowedClassNames.length);
            for (String allowedClassName : allowedClassNames) {
                if (Validator.isBlank((String)(allowedClassName = StringUtil.trim((String)allowedClassName)))) continue;
                this._allowedClassNames.add(allowedClassName);
            }
        }
        if (restrictedMethodNames == null) {
            this._deniedAccessToStringClasses = Collections.emptySet();
            this._restrictedMethodNames = Collections.emptyMap();
        } else {
            this._deniedAccessToStringClasses = new HashSet<String>();
            this._restrictedMethodNames = new HashMap<String, Set<String>>();
            for (String restrictedMethodName : restrictedMethodNames) {
                int index = restrictedMethodName.indexOf(35);
                if (index < 0) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"\"", restrictedMethodName, "\" does not match format ", "\"className#methodName\""}));
                    continue;
                }
                String className = StringUtil.trim((String)restrictedMethodName.substring(0, index));
                String methodName = StringUtil.trim((String)restrictedMethodName.substring(index + 1));
                if (methodName.equals("toString")) {
                    this._deniedAccessToStringClasses.add(className);
                }
                Set methodNames = this._restrictedMethodNames.computeIfAbsent(className, key -> new HashSet());
                methodNames.add(StringUtil.toLowerCase((String)methodName));
            }
        }
        this._allowAllClasses = this._allowedClassNames.contains("*");
        if (restrictedClassNames == null) {
            this._restrictedClasses = Collections.emptyList();
            this._restrictedPackageNames = Collections.emptyList();
        } else {
            this._restrictedClasses = new ArrayList(restrictedClassNames.length);
            this._restrictedPackageNames = new ArrayList<String>();
            AggregateClassLoader aggregateClassLoader = new AggregateClassLoader(LiferayObjectWrapper.class.getClassLoader());
            aggregateClassLoader.addClassLoader(PortalImpl.class.getClassLoader());
            Thread thread = Thread.currentThread();
            if (thread.getContextClassLoader() != null) {
                aggregateClassLoader.addClassLoader(thread.getContextClassLoader());
            }
            for (String restrictedClassName : restrictedClassNames) {
                if (Validator.isBlank((String)(restrictedClassName = StringUtil.trim((String)restrictedClassName)))) continue;
                try {
                    this._restrictedClasses.add(aggregateClassLoader.loadClass(restrictedClassName));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Unable to find restricted class ", restrictedClassName, ". Registering as a package."}), (Throwable)classNotFoundException);
                    }
                    if (restrictedClassName.endsWith("*")) {
                        restrictedClassName = restrictedClassName.substring(0, restrictedClassName.length() - 1);
                    }
                    this._restrictedPackageNames.add(restrictedClassName);
                }
            }
        }
    }

    @Override
    public TemplateModel wrap(Object object) throws TemplateModelException {
        AopInvocationHandler aopInvocationHandler;
        BaseModel baseModel;
        Map getterFunctions;
        Function function;
        long currentCompanyId;
        if (object == null) {
            return null;
        }
        if (object instanceof TemplateModel) {
            return (TemplateModel)object;
        }
        Class<?> clazz = object.getClass();
        if (PropsValues.TEMPLATE_ENGINE_FREEMARKER_COMPANY_RESTRICT && object instanceof BaseModel && !CompanyThreadLocal.isInitializingPortalInstance() && (currentCompanyId = CompanyThreadLocal.getCompanyId().longValue()) != 0L && (function = (Function)(getterFunctions = (baseModel = (BaseModel)object).getAttributeGetterFunctions()).get("companyId")) != null && currentCompanyId != (Long)function.apply(object)) {
            throw new TemplateModelException(StringBundler.concat((Object[])new Object[]{"Denied access to model object as it does not ", "belong to current company ", currentCompanyId}));
        }
        if (!this._allowAllClasses && this._isRestricted(clazz)) {
            return _RESTRICTED_STRING_MODEL_FACTORY.create(object, this);
        }
        String className = clazz.getName();
        if (this._restrictedMethodNames.containsKey(className)) {
            LiferayFreeMarkerStringModel liferayFreeMarkerStringModel = (LiferayFreeMarkerStringModel)_RESTRICTED_STRING_MODEL_FACTORY.create(object, this);
            liferayFreeMarkerStringModel.setDeniedAccessToString(this._deniedAccessToStringClasses.contains(className));
            liferayFreeMarkerStringModel.setRestrictedMethodNames(this._restrictedMethodNames.get(className));
            return liferayFreeMarkerStringModel;
        }
        if (this._serviceProxyClassNames.contains(className)) {
            return _SERVICE_PROXY_STRING_MODEL_FACTORY.create(object, this);
        }
        if ((object instanceof BaseLocalService || object instanceof BaseService) && (aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)object, AopInvocationHandler.class)) != null) {
            this._serviceProxyClassNames.add(className);
            return _SERVICE_PROXY_STRING_MODEL_FACTORY.create(object, this);
        }
        return super.wrap(object);
    }

    private boolean _isRestricted(Class<?> clazz) {
        return this._restrictedClassMap.computeIfAbsent(clazz.getName(), className -> {
            if (this._allowedClassNames.contains(className)) {
                return false;
            }
            for (Class<?> restrictedClass : this._restrictedClasses) {
                if (!restrictedClass.isAssignableFrom(clazz)) continue;
                return true;
            }
            int index = className.lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            String packageName = className.substring(0, index);
            packageName = packageName.concat(".");
            for (String restrictedPackageName : this._restrictedPackageNames) {
                if (!packageName.startsWith(restrictedPackageName)) continue;
                return true;
            }
            return false;
        });
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.REQUIRES_NEW);
        builder.setStrictReadOnly(PropsValues.TEMPLATE_ENGINE_FREEMARKER_TRANSACTION_READ_ONLY);
        builder.setRollbackForClasses(new Class[]{Exception.class});
        _transactionConfig = builder.build();
    }
}

