/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class FreeMarkerBundleClassloader
extends URLClassLoader {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerBundleClassloader.class);
    private final Set<ClassLoader> _classLoaders;

    public FreeMarkerBundleClassloader(Set<ClassLoader> classLoaders) {
        super(new URL[0]);
        this._classLoaders = new HashSet<ClassLoader>(classLoaders);
        Class<FreeMarkerBundleClassloader> clazz = FreeMarkerBundleClassloader.class;
        this._classLoaders.add(clazz.getClassLoader());
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader classLoader : this._classLoaders) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        for (ClassLoader classLoader : this._classLoaders) {
            try {
                Enumeration<URL> enumeration = classLoader.getResources(name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                return enumeration;
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)ioException);
            }
        }
        return Collections.enumeration(Collections.emptyList());
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this._classLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)classNotFoundException);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

