/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;

public class LiferayObjectConstructor
implements TemplateMethodModelEx {
    private static final Log _log = LogFactoryUtil.getLog(LiferayObjectConstructor.class);
    private final BeansWrapper _beansWrapper;

    public LiferayObjectConstructor(BeansWrapper beansWrapper) {
        this._beansWrapper = beansWrapper;
    }

    @Override
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.isEmpty()) {
            throw new TemplateModelException("This method must have at least one argument as the name of the class to instantiate");
        }
        String className = String.valueOf(arguments.get(0));
        Thread currentThread = Thread.currentThread();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, currentThread.getContextClassLoader());
        }
        catch (Exception exception1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception1);
            }
            try {
                clazz = Class.forName(className, true, PortalClassLoaderUtil.getClassLoader());
            }
            catch (Exception exception2) {
                throw new TemplateModelException(exception2.getMessage());
            }
        }
        Object object = this._beansWrapper.newInstance(clazz, arguments.subList(1, arguments.size()));
        return this._beansWrapper.wrap(object);
    }
}

