/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.persistence.internal.upgrade.v2_2_0;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.model.OAuthClientEntryTable;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.cm.file.ConfigurationHandler;

public class OpenIdConnectProviderConfigurationUpgradeProcess
extends UpgradeProcess {
    private final OAuthClientEntryLocalService _oAuthClientEntryLocalService;

    public OpenIdConnectProviderConfigurationUpgradeProcess(OAuthClientEntryLocalService oAuthClientEntryLocalService) {
        this._oAuthClientEntryLocalService = oAuthClientEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("Configuration_")) {
            return;
        }
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(StringBundler.concat((String[])new String[]{"select * from Configuration_ where configurationId LIKE ", "'%com.liferay.portal.security.sso.openid.connect.", "internal.configuration.", "OpenIdConnectProviderConfiguration%'"}));
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Configuration_ set dictionary = ? where configurationId = ?");){
            while (resultSet.next()) {
                String dictionaryString = resultSet.getString("dictionary");
                if (Validator.isNull((String)dictionaryString)) {
                    return;
                }
                Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
                dictionary = HashMapDictionaryBuilder.putAll((Dictionary)dictionary).put((Object)"authorizationEndpoint", (Object)GetterUtil.getString(dictionary.get("authorizationEndPoint"))).put((Object)"discoveryEndpoint", (Object)GetterUtil.getString(dictionary.get("discoveryEndPoint"))).put((Object)"discoveryEndpointCacheInMillis", (Object)GetterUtil.getLong(dictionary.get("discoveryEndPointCacheInMillis"))).put((Object)"tokenEndpoint", (Object)GetterUtil.getString(dictionary.get("tokenEndPoint"))).put((Object)"userInfoEndpoint", (Object)GetterUtil.getString(dictionary.get("userInfoEndPoint"))).remove((Object)"authorizationEndPoint").remove((Object)"discoveryEndPoint").remove((Object)"discoveryEndPointCacheInMillis").remove((Object)"tokenEndPoint").remove((Object)"userInfoEndPoint").build();
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ConfigurationHandler.write((OutputStream)unsyncByteArrayOutputStream, (Dictionary)dictionary);
                preparedStatement.setString(1, unsyncByteArrayOutputStream.toString());
                preparedStatement.setString(2, resultSet.getString("configurationId"));
                preparedStatement.addBatch();
                this._updateOAuthClientEntry(GetterUtil.getLong(dictionary.get("companyId")), GetterUtil.getLong(dictionary.get("discoveryEndpointCacheInMillis")), GetterUtil.getString(dictionary.get("openIdConnectClientId")));
            }
            preparedStatement.executeBatch();
        }
    }

    private void _updateOAuthClientEntry(long companyId, long discoveryEndpointCacheInMillis, String openIdConnectClientId) {
        List oAuthClientEntries = (List)this._oAuthClientEntryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)OAuthClientEntryTable.INSTANCE).from((Table)OAuthClientEntryTable.INSTANCE).where(Predicate.and((Predicate)OAuthClientEntryTable.INSTANCE.clientId.eq((Object)openIdConnectClientId), (Predicate)OAuthClientEntryTable.INSTANCE.companyId.eq((Object)companyId))));
        if (oAuthClientEntries.isEmpty()) {
            return;
        }
        OAuthClientEntry oAuthClientEntry = (OAuthClientEntry)oAuthClientEntries.get(0);
        oAuthClientEntry.setMetadataCacheTime(discoveryEndpointCacheInMillis);
        this._oAuthClientEntryLocalService.updateOAuthClientEntry(oAuthClientEntry);
    }
}

