/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.persistence.internal.upgrade.v2_1_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import net.minidev.json.JSONObject;

public class OpenIdConnectSessionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        block17: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select openIdConnectSessionId, modifiedDate, accessToken from OpenIdConnectSession");){
                ResultSet resultSet = preparedStatement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        long openIdConnectSessionId = resultSet.getLong("openIdConnectSessionId");
                        try {
                            this._upgradeOpenIdConnectSession(openIdConnectSessionId, resultSet.getTimestamp("modifiedDate"), AccessToken.parse((JSONObject)JSONObjectUtils.parse((String)resultSet.getString("accessToken"))));
                            continue block12;
                        }
                        catch (Exception exception) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Throwable)exception);
                            }
                            this.runSQL("delete from OpenIdConnectSession where openIdConnectSessionId = " + openIdConnectSessionId);
                        }
                    }
                    break block17;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"OpenIdConnectSession", (String[])new String[]{"accessTokenExpirationDate DATE null"})};
    }

    private void _upgradeOpenIdConnectSession(long openIdConnectSessionId, Timestamp modifiedDate, AccessToken accessToken) throws Exception {
        long accessTokenLifetime = accessToken.getLifetime() * 1000L;
        if (accessTokenLifetime == 0L) {
            accessTokenLifetime = 3600000L;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update OpenIdConnectSession set accessTokenExpirationDate = ? where openIdConnectSessionId = ?");){
            preparedStatement.setTimestamp(1, new Timestamp(modifiedDate.getTime() + accessTokenLifetime));
            preparedStatement.setLong(2, openIdConnectSessionId);
            preparedStatement.execute();
        }
    }
}

