/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.persistence.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.service.base.OpenIdConnectSessionLocalServiceBaseImpl;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession"}, service={AopService.class})
public class OpenIdConnectSessionLocalServiceImpl
extends OpenIdConnectSessionLocalServiceBaseImpl {
    public void deleteOpenIdConnectSessions(long userId) {
        this.openIdConnectSessionPersistence.removeByUserId(userId);
    }

    public void deleteOpenIdConnectSessions(long companyId, String authServerWellKnownURI, String clientId) {
        this.openIdConnectSessionPersistence.removeByC_A_C(companyId, authServerWellKnownURI, clientId);
    }

    public OpenIdConnectSession fetchCurrentOpenIdConnectSession() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return this.openIdConnectSessionPersistence.fetchByPrimaryKey(GetterUtil.getLong((Object)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID")));
    }

    public OpenIdConnectSession fetchOpenIdConnectSession(long userId, String authServerWellKnownURI, String clientId) {
        return this.openIdConnectSessionPersistence.fetchByU_A_C(userId, authServerWellKnownURI, clientId);
    }

    public List<OpenIdConnectSession> getAccessTokenExpirationDateOpenIdConnectSessions(Date ltAccessTokenExpirationDate, int start, int end) {
        return this.openIdConnectSessionPersistence.findByLtAccessTokenExpirationDate(ltAccessTokenExpirationDate, start, end);
    }
}

