/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.security.sso.openid.connect.persistence.model.impl;

import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.service.OpenIdConnectSessionLocalServiceUtil;

/**
 * The extended model base implementation for the OpenIdConnectSession service. Represents a row in the &quot;OpenIdConnectSession&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OpenIdConnectSessionImpl}.
 * </p>
 *
 * @author Arthur Chan
 * @see OpenIdConnectSessionImpl
 * @see OpenIdConnectSession
 * @generated
 */
public abstract class OpenIdConnectSessionBaseImpl
	extends OpenIdConnectSessionModelImpl implements OpenIdConnectSession {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a open ID connect session model instance should use the <code>OpenIdConnectSession</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OpenIdConnectSessionLocalServiceUtil.addOpenIdConnectSession(this);
		}
		else {
			OpenIdConnectSessionLocalServiceUtil.updateOpenIdConnectSession(
				this);
		}
	}

}