/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.persistence.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.sso.openid.connect.persistence.exception.NoSuchSessionException;
import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSessionTable;
import com.liferay.portal.security.sso.openid.connect.persistence.model.impl.OpenIdConnectSessionImpl;
import com.liferay.portal.security.sso.openid.connect.persistence.model.impl.OpenIdConnectSessionModelImpl;
import com.liferay.portal.security.sso.openid.connect.persistence.service.persistence.OpenIdConnectSessionPersistence;
import com.liferay.portal.security.sso.openid.connect.persistence.service.persistence.OpenIdConnectSessionUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIdConnectSessionPersistence.class})
public class OpenIdConnectSessionPersistenceImpl
extends BasePersistenceImpl<OpenIdConnectSession>
implements OpenIdConnectSessionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OpenIdConnectSessionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "openIdConnectSession.userId = ?";
    private FinderPath _finderPathWithPaginationFindByConfigurationPid;
    private FinderPath _finderPathWithoutPaginationFindByConfigurationPid;
    private FinderPath _finderPathCountByConfigurationPid;
    private static final String _FINDER_COLUMN_CONFIGURATIONPID_CONFIGURATIONPID_2 = "openIdConnectSession.configurationPid = ?";
    private static final String _FINDER_COLUMN_CONFIGURATIONPID_CONFIGURATIONPID_3 = "(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')";
    private FinderPath _finderPathFetchByU_C;
    private FinderPath _finderPathCountByU_C;
    private static final String _FINDER_COLUMN_U_C_USERID_2 = "openIdConnectSession.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_C_CONFIGURATIONPID_2 = "openIdConnectSession.configurationPid = ?";
    private static final String _FINDER_COLUMN_U_C_CONFIGURATIONPID_3 = "(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OPENIDCONNECTSESSION = "SELECT openIdConnectSession FROM OpenIdConnectSession openIdConnectSession";
    private static final String _SQL_SELECT_OPENIDCONNECTSESSION_WHERE = "SELECT openIdConnectSession FROM OpenIdConnectSession openIdConnectSession WHERE ";
    private static final String _SQL_COUNT_OPENIDCONNECTSESSION = "SELECT COUNT(openIdConnectSession) FROM OpenIdConnectSession openIdConnectSession";
    private static final String _SQL_COUNT_OPENIDCONNECTSESSION_WHERE = "SELECT COUNT(openIdConnectSession) FROM OpenIdConnectSession openIdConnectSession WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "openIdConnectSession.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OpenIdConnectSession exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OpenIdConnectSession exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionPersistenceImpl.class);
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<OpenIdConnectSession> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OpenIdConnectSession> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OpenIdConnectSession> findByUserId(long userId, int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OpenIdConnectSession> findByUserId(long userId, int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OpenIdConnectSession openIdConnectSession : list) {
                if (userId == openIdConnectSession.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OPENIDCONNECTSESSION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY openIdConnectSession.openIdConnectSessionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OpenIdConnectSession findByUserId_First(long userId, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.fetchByUserId_First(userId, orderByComparator);
        if (openIdConnectSession != null) {
            return openIdConnectSession;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchSessionException(sb.toString());
    }

    public OpenIdConnectSession fetchByUserId_First(long userId, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        List<OpenIdConnectSession> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OpenIdConnectSession findByUserId_Last(long userId, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.fetchByUserId_Last(userId, orderByComparator);
        if (openIdConnectSession != null) {
            return openIdConnectSession;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchSessionException(sb.toString());
    }

    public OpenIdConnectSession fetchByUserId_Last(long userId, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OpenIdConnectSession> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OpenIdConnectSession[] findByUserId_PrevAndNext(long openIdConnectSessionId, long userId, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.findByPrimaryKey(openIdConnectSessionId);
        Session session = null;
        try {
            session = this.openSession();
            OpenIdConnectSession[] array = new OpenIdConnectSessionImpl[]{this.getByUserId_PrevAndNext(session, openIdConnectSession, userId, orderByComparator, true), openIdConnectSession, this.getByUserId_PrevAndNext(session, openIdConnectSession, userId, orderByComparator, false)};
            OpenIdConnectSession[] openIdConnectSessionArray = array;
            return openIdConnectSessionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OpenIdConnectSession getByUserId_PrevAndNext(Session session, OpenIdConnectSession openIdConnectSession, long userId, OrderByComparator<OpenIdConnectSession> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OPENIDCONNECTSESSION_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY openIdConnectSession.openIdConnectSessionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)openIdConnectSession)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OpenIdConnectSession)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OpenIdConnectSession openIdConnectSession : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)openIdConnectSession);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OPENIDCONNECTSESSION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OpenIdConnectSession> findByConfigurationPid(String configurationPid) {
        return this.findByConfigurationPid(configurationPid, -1, -1, null);
    }

    public List<OpenIdConnectSession> findByConfigurationPid(String configurationPid, int start, int end) {
        return this.findByConfigurationPid(configurationPid, start, end, null);
    }

    public List<OpenIdConnectSession> findByConfigurationPid(String configurationPid, int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        return this.findByConfigurationPid(configurationPid, start, end, orderByComparator, true);
    }

    public List<OpenIdConnectSession> findByConfigurationPid(String configurationPid, int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator, boolean useFinderCache) {
        configurationPid = Objects.toString(configurationPid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByConfigurationPid;
                finderArgs = new Object[]{configurationPid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByConfigurationPid;
            finderArgs = new Object[]{configurationPid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OpenIdConnectSession openIdConnectSession : list) {
                if (configurationPid.equals(openIdConnectSession.getConfigurationPid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OPENIDCONNECTSESSION_WHERE);
            boolean bindConfigurationPid = false;
            if (configurationPid.isEmpty()) {
                sb.append("(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')");
            } else {
                bindConfigurationPid = true;
                sb.append("openIdConnectSession.configurationPid = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY openIdConnectSession.openIdConnectSessionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindConfigurationPid) {
                    queryPos.add(configurationPid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OpenIdConnectSession findByConfigurationPid_First(String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.fetchByConfigurationPid_First(configurationPid, orderByComparator);
        if (openIdConnectSession != null) {
            return openIdConnectSession;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("configurationPid=");
        sb.append(configurationPid);
        sb.append("}");
        throw new NoSuchSessionException(sb.toString());
    }

    public OpenIdConnectSession fetchByConfigurationPid_First(String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        List<OpenIdConnectSession> list = this.findByConfigurationPid(configurationPid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OpenIdConnectSession findByConfigurationPid_Last(String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.fetchByConfigurationPid_Last(configurationPid, orderByComparator);
        if (openIdConnectSession != null) {
            return openIdConnectSession;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("configurationPid=");
        sb.append(configurationPid);
        sb.append("}");
        throw new NoSuchSessionException(sb.toString());
    }

    public OpenIdConnectSession fetchByConfigurationPid_Last(String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        int count = this.countByConfigurationPid(configurationPid);
        if (count == 0) {
            return null;
        }
        List<OpenIdConnectSession> list = this.findByConfigurationPid(configurationPid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OpenIdConnectSession[] findByConfigurationPid_PrevAndNext(long openIdConnectSessionId, String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator) throws NoSuchSessionException {
        configurationPid = Objects.toString(configurationPid, "");
        OpenIdConnectSession openIdConnectSession = this.findByPrimaryKey(openIdConnectSessionId);
        Session session = null;
        try {
            session = this.openSession();
            OpenIdConnectSession[] array = new OpenIdConnectSessionImpl[]{this.getByConfigurationPid_PrevAndNext(session, openIdConnectSession, configurationPid, orderByComparator, true), openIdConnectSession, this.getByConfigurationPid_PrevAndNext(session, openIdConnectSession, configurationPid, orderByComparator, false)};
            OpenIdConnectSession[] openIdConnectSessionArray = array;
            return openIdConnectSessionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OpenIdConnectSession getByConfigurationPid_PrevAndNext(Session session, OpenIdConnectSession openIdConnectSession, String configurationPid, OrderByComparator<OpenIdConnectSession> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OPENIDCONNECTSESSION_WHERE);
        boolean bindConfigurationPid = false;
        if (configurationPid.isEmpty()) {
            sb.append("(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')");
        } else {
            bindConfigurationPid = true;
            sb.append("openIdConnectSession.configurationPid = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY openIdConnectSession.openIdConnectSessionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindConfigurationPid) {
            queryPos.add(configurationPid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)openIdConnectSession)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OpenIdConnectSession)list.get(1);
        }
        return null;
    }

    public void removeByConfigurationPid(String configurationPid) {
        for (OpenIdConnectSession openIdConnectSession : this.findByConfigurationPid(configurationPid, -1, -1, null)) {
            this.remove((BaseModel)openIdConnectSession);
        }
    }

    public int countByConfigurationPid(String configurationPid) {
        configurationPid = Objects.toString(configurationPid, "");
        FinderPath finderPath = this._finderPathCountByConfigurationPid;
        Object[] finderArgs = new Object[]{configurationPid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OPENIDCONNECTSESSION_WHERE);
            boolean bindConfigurationPid = false;
            if (configurationPid.isEmpty()) {
                sb.append("(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')");
            } else {
                bindConfigurationPid = true;
                sb.append("openIdConnectSession.configurationPid = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindConfigurationPid) {
                    queryPos.add(configurationPid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OpenIdConnectSession findByU_C(long userId, String configurationPid) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.fetchByU_C(userId, configurationPid);
        if (openIdConnectSession == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append(", configurationPid=");
            sb.append(configurationPid);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchSessionException(sb.toString());
        }
        return openIdConnectSession;
    }

    public OpenIdConnectSession fetchByU_C(long userId, String configurationPid) {
        return this.fetchByU_C(userId, configurationPid, true);
    }

    public OpenIdConnectSession fetchByU_C(long userId, String configurationPid, boolean useFinderCache) {
        OpenIdConnectSession openIdConnectSession;
        configurationPid = Objects.toString(configurationPid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId, configurationPid};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByU_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof OpenIdConnectSession && (userId != (openIdConnectSession = (OpenIdConnectSession)result).getUserId() || !Objects.equals(configurationPid, openIdConnectSession.getConfigurationPid()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OPENIDCONNECTSESSION_WHERE);
            sb.append(_FINDER_COLUMN_U_C_USERID_2);
            boolean bindConfigurationPid = false;
            if (configurationPid.isEmpty()) {
                sb.append("(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')");
            } else {
                bindConfigurationPid = true;
                sb.append("openIdConnectSession.configurationPid = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindConfigurationPid) {
                    queryPos.add(configurationPid);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByU_C, finderArgs, (Object)list);
                    }
                } else {
                    OpenIdConnectSession openIdConnectSession2 = (OpenIdConnectSession)list.get(0);
                    result = openIdConnectSession2;
                    this.cacheResult(openIdConnectSession2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OpenIdConnectSession)result;
    }

    public OpenIdConnectSession removeByU_C(long userId, String configurationPid) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = this.findByU_C(userId, configurationPid);
        return (OpenIdConnectSession)this.remove((BaseModel)openIdConnectSession);
    }

    public int countByU_C(long userId, String configurationPid) {
        configurationPid = Objects.toString(configurationPid, "");
        FinderPath finderPath = this._finderPathCountByU_C;
        Object[] finderArgs = new Object[]{userId, configurationPid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OPENIDCONNECTSESSION_WHERE);
            sb.append(_FINDER_COLUMN_U_C_USERID_2);
            boolean bindConfigurationPid = false;
            if (configurationPid.isEmpty()) {
                sb.append("(openIdConnectSession.configurationPid IS NULL OR openIdConnectSession.configurationPid = '')");
            } else {
                bindConfigurationPid = true;
                sb.append("openIdConnectSession.configurationPid = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindConfigurationPid) {
                    queryPos.add(configurationPid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OpenIdConnectSessionPersistenceImpl() {
        this.setModelClass(OpenIdConnectSession.class);
        this.setModelImplClass(OpenIdConnectSessionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)OpenIdConnectSessionTable.INSTANCE);
    }

    public void cacheResult(OpenIdConnectSession openIdConnectSession) {
        this.entityCache.putResult(OpenIdConnectSessionImpl.class, (Serializable)Long.valueOf(openIdConnectSession.getPrimaryKey()), (Serializable)openIdConnectSession);
        this.finderCache.putResult(this._finderPathFetchByU_C, new Object[]{openIdConnectSession.getUserId(), openIdConnectSession.getConfigurationPid()}, (Object)openIdConnectSession);
    }

    public void cacheResult(List<OpenIdConnectSession> openIdConnectSessions) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && openIdConnectSessions.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OpenIdConnectSession openIdConnectSession : openIdConnectSessions) {
            if (this.entityCache.getResult(OpenIdConnectSessionImpl.class, (Serializable)Long.valueOf(openIdConnectSession.getPrimaryKey())) != null) continue;
            this.cacheResult(openIdConnectSession);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OpenIdConnectSessionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OpenIdConnectSession openIdConnectSession) {
        this.entityCache.removeResult(OpenIdConnectSessionImpl.class, (BaseModel)openIdConnectSession);
    }

    public void clearCache(List<OpenIdConnectSession> openIdConnectSessions) {
        for (OpenIdConnectSession openIdConnectSession : openIdConnectSessions) {
            this.entityCache.removeResult(OpenIdConnectSessionImpl.class, (BaseModel)openIdConnectSession);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OpenIdConnectSessionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OpenIdConnectSessionModelImpl openIdConnectSessionModelImpl) {
        Object[] args = new Object[]{openIdConnectSessionModelImpl.getUserId(), openIdConnectSessionModelImpl.getConfigurationPid()};
        this.finderCache.putResult(this._finderPathCountByU_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByU_C, args, (Object)openIdConnectSessionModelImpl, false);
    }

    public OpenIdConnectSession create(long openIdConnectSessionId) {
        OpenIdConnectSessionImpl openIdConnectSession = new OpenIdConnectSessionImpl();
        openIdConnectSession.setNew(true);
        openIdConnectSession.setPrimaryKey(openIdConnectSessionId);
        openIdConnectSession.setCompanyId(CompanyThreadLocal.getCompanyId());
        return openIdConnectSession;
    }

    public OpenIdConnectSession remove(long openIdConnectSessionId) throws NoSuchSessionException {
        return this.remove(Long.valueOf(openIdConnectSessionId));
    }

    public OpenIdConnectSession remove(Serializable primaryKey) throws NoSuchSessionException {
        Session session = null;
        try {
            session = this.openSession();
            OpenIdConnectSession openIdConnectSession = (OpenIdConnectSession)session.get(OpenIdConnectSessionImpl.class, primaryKey);
            if (openIdConnectSession == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchSessionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OpenIdConnectSession openIdConnectSession2 = (OpenIdConnectSession)this.remove((BaseModel)openIdConnectSession);
            return openIdConnectSession2;
        }
        catch (NoSuchSessionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OpenIdConnectSession removeImpl(OpenIdConnectSession openIdConnectSession) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)openIdConnectSession)) {
                openIdConnectSession = (OpenIdConnectSession)session.get(OpenIdConnectSessionImpl.class, openIdConnectSession.getPrimaryKeyObj());
            }
            if (openIdConnectSession != null) {
                session.delete((Object)openIdConnectSession);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (openIdConnectSession != null) {
            this.clearCache(openIdConnectSession);
        }
        return openIdConnectSession;
    }

    public OpenIdConnectSession updateImpl(OpenIdConnectSession openIdConnectSession) {
        boolean isNew = openIdConnectSession.isNew();
        if (!(openIdConnectSession instanceof OpenIdConnectSessionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(openIdConnectSession.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)openIdConnectSession);
                throw new IllegalArgumentException("Implement ModelWrapper in openIdConnectSession proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OpenIdConnectSession implementation " + openIdConnectSession.getClass());
        }
        OpenIdConnectSessionModelImpl openIdConnectSessionModelImpl = (OpenIdConnectSessionModelImpl)openIdConnectSession;
        if (!openIdConnectSessionModelImpl.hasSetModifiedDate()) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                openIdConnectSession.setModifiedDate(date);
            } else {
                openIdConnectSession.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)openIdConnectSession);
            } else {
                openIdConnectSession = (OpenIdConnectSession)session.merge((Object)openIdConnectSession);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(OpenIdConnectSessionImpl.class, (BaseModel)openIdConnectSessionModelImpl, false, true);
        this.cacheUniqueFindersCache(openIdConnectSessionModelImpl);
        if (isNew) {
            openIdConnectSession.setNew(false);
        }
        openIdConnectSession.resetOriginalValues();
        return openIdConnectSession;
    }

    public OpenIdConnectSession findByPrimaryKey(Serializable primaryKey) throws NoSuchSessionException {
        OpenIdConnectSession openIdConnectSession = (OpenIdConnectSession)this.fetchByPrimaryKey(primaryKey);
        if (openIdConnectSession == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchSessionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return openIdConnectSession;
    }

    public OpenIdConnectSession findByPrimaryKey(long openIdConnectSessionId) throws NoSuchSessionException {
        return this.findByPrimaryKey(Long.valueOf(openIdConnectSessionId));
    }

    public OpenIdConnectSession fetchByPrimaryKey(long openIdConnectSessionId) {
        return (OpenIdConnectSession)this.fetchByPrimaryKey(Long.valueOf(openIdConnectSessionId));
    }

    public List<OpenIdConnectSession> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OpenIdConnectSession> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OpenIdConnectSession> findAll(int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OpenIdConnectSession> findAll(int start, int end, OrderByComparator<OpenIdConnectSession> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OPENIDCONNECTSESSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OPENIDCONNECTSESSION;
                sql = sql.concat(" ORDER BY openIdConnectSession.openIdConnectSessionId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OpenIdConnectSession openIdConnectSession : this.findAll()) {
            this.remove((BaseModel)openIdConnectSession);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OPENIDCONNECTSESSION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "openIdConnectSessionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OPENIDCONNECTSESSION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OpenIdConnectSessionModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new OpenIdConnectSessionModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)OpenIdConnectSession.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathWithPaginationFindByConfigurationPid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByConfigurationPid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"configurationPid"}, true);
        this._finderPathWithoutPaginationFindByConfigurationPid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByConfigurationPid", new String[]{String.class.getName()}, new String[]{"configurationPid"}, true);
        this._finderPathCountByConfigurationPid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByConfigurationPid", new String[]{String.class.getName()}, new String[]{"configurationPid"}, false);
        this._finderPathFetchByU_C = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByU_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "configurationPid"}, true);
        this._finderPathCountByU_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByU_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "configurationPid"}, false);
        OpenIdConnectSessionUtil.setPersistence((OpenIdConnectSessionPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        OpenIdConnectSessionUtil.setPersistence(null);
        this.entityCache.removeCache(OpenIdConnectSessionImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.portal.security.sso.openid.connect.persistence.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.security.sso.openid.connect.persistence.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.security.sso.openid.connect.persistence.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class OpenIdConnectSessionModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private OpenIdConnectSessionModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            OpenIdConnectSessionModelImpl openIdConnectSessionModelImpl = (OpenIdConnectSessionModelImpl)baseModel;
            long columnBitmask = openIdConnectSessionModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return OpenIdConnectSessionModelArgumentsResolver._getValue(openIdConnectSessionModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | OpenIdConnectSessionModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return OpenIdConnectSessionModelArgumentsResolver._getValue(openIdConnectSessionModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(OpenIdConnectSessionModelImpl openIdConnectSessionModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? openIdConnectSessionModelImpl.getColumnOriginalValue(columnName) : openIdConnectSessionModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

