/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scheduler.internal.messaging.config.ScriptingMessageListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, service={SchedulerEngineHelper.class})
public class SchedulerEngineHelperImpl
implements SchedulerEngineHelper {
    private static final Log _log = LogFactoryUtil.getLog(SchedulerEngineHelperImpl.class);
    private volatile BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private final Map<String, ServiceRegistration<MessageListener>> _messageListenerServiceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<MessageListener>>();
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference(target="(scheduler.engine.proxy=true)")
    private SchedulerEngine _schedulerEngine;
    private ServiceTracker<SchedulerJobConfiguration, SchedulerJobConfiguration> _schedulerJobConfigurationServiceTracker;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    @Reference
    private TriggerFactory _triggerFactory;

    public void addScriptingJob(Trigger trigger, StorageType storageType, String description, String language, String script) throws SchedulerException {
        Message message = new Message();
        message.put("LANGUAGE", (Object)language);
        message.put("SCRIPT", (Object)script);
        this.schedule(trigger, storageType, description, "liferay/scheduler_scripting", message);
    }

    public void delete(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(groupName, storageType);
    }

    public void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(jobName, groupName, storageType);
    }

    public Date getEndTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("END_TIME");
        }
        return jobState.getTriggerDate("END_TIME");
    }

    public TriggerState getJobState(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getTriggerState();
    }

    public Date getNextFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("NEXT_FIRE_TIME");
        }
        return jobState.getTriggerDate("NEXT_FIRE_TIME");
    }

    public Date getPreviousFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("PREVIOUS_FIRE_TIME");
        }
        return jobState.getTriggerDate("PREVIOUS_FIRE_TIME");
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJob(jobName, groupName, storageType);
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs();
    }

    public List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(storageType);
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(groupName, storageType);
    }

    public Date getStartTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("START_TIME");
        }
        return jobState.getTriggerDate("START_TIME");
    }

    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(jobName, groupName, storageType);
    }

    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(jobName, groupName, storageType);
    }

    public void run(long companyId, String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.run(companyId, jobName, groupName, storageType);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Message message) throws SchedulerException {
        this._schedulerEngine.validateTrigger(trigger, storageType);
        if (message == null) {
            message = new Message();
        }
        this._schedulerEngine.schedule(trigger, description, destinationName, message, storageType);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        this.schedule(trigger, storageType, description, destinationName, message);
    }

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this._bundleContext = componentContext.getBundleContext();
        this._registerMessaging(this._bundleContext, "liferay/scheduler_dispatch", null);
        final ScriptingMessageListener scriptingMessageListener = new ScriptingMessageListener();
        this._registerMessaging(this._bundleContext, "liferay/scheduler_scripting", new SchedulerJobConfigurationMessageListener(new SchedulerJobConfiguration(){

            public UnsafeConsumer<Message, Exception> getJobExecutorUnsafeConsumer() {
                return arg_0 -> ((ScriptingMessageListener)scriptingMessageListener).receive(arg_0);
            }

            public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
                return null;
            }

            public TriggerConfiguration getTriggerConfiguration() {
                return null;
            }
        }));
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            this._schedulerJobConfigurationServiceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, SchedulerJobConfiguration.class, (ServiceTrackerCustomizer)new SchedulerJobConfigurationServiceTrackerCustomizer());
            this._schedulerEngine.start();
            return null;
        });
    }

    @Deactivate
    protected void deactivate() {
        block5: {
            if (this._bundleContext == null) {
                return;
            }
            if (this._schedulerJobConfigurationServiceTracker != null) {
                this._schedulerJobConfigurationServiceTracker.close();
            }
            try {
                this._schedulerEngine.shutdown();
            }
            catch (SchedulerException schedulerException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to shutdown scheduler", (Throwable)schedulerException);
            }
        }
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._bundleContext = null;
    }

    private void _registerMessaging(BundleContext bundleContext, String destinationName, MessageListener messageListener) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        Dictionary dictionary = MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName());
        this._serviceRegistrations.add(bundleContext.registerService(Destination.class, (Object)destination, dictionary));
        if (messageListener == null) {
            return;
        }
        this._serviceRegistrations.add(bundleContext.registerService(MessageListener.class, (Object)messageListener, dictionary));
    }

    private class SchedulerJobConfigurationMessageListener
    implements MessageListener {
        private final SchedulerJobConfiguration _schedulerJobConfiguration;

        public void receive(Message message) throws MessageListenerException {
            if (!Objects.equals(this._schedulerJobConfiguration.getName(), message.getString("GROUP_NAME")) || !Objects.equals(this._schedulerJobConfiguration.getName(), message.getString("JOB_NAME"))) {
                return;
            }
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                UnsafeConsumer unsafeConsumer = this._schedulerJobConfiguration.getJobExecutorUnsafeConsumer();
                if (unsafeConsumer != null) {
                    unsafeConsumer.accept((Object)message);
                } else {
                    long companyId = message.getLong("companyId");
                    if (companyId == 0L) {
                        UnsafeRunnable jobExecutorUnsafeRunnable = this._schedulerJobConfiguration.getJobExecutorUnsafeRunnable();
                        jobExecutorUnsafeRunnable.run();
                    } else {
                        UnsafeConsumer companyJobExecutorUnsafeConsumer = this._schedulerJobConfiguration.getCompanyJobExecutorUnsafeConsumer();
                        companyJobExecutorUnsafeConsumer.accept((Object)companyId);
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof MessageListenerException) {
                    throw (MessageListenerException)exception;
                }
                throw new MessageListenerException((Throwable)exception);
            }
        }

        private SchedulerJobConfigurationMessageListener(SchedulerJobConfiguration schedulerJobConfiguration) {
            this._schedulerJobConfiguration = schedulerJobConfiguration;
        }
    }

    private class SchedulerJobConfigurationServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SchedulerJobConfiguration, SchedulerJobConfiguration> {
        private SchedulerJobConfigurationServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SchedulerJobConfiguration addingService(ServiceReference<SchedulerJobConfiguration> serviceReference) {
            SchedulerJobConfiguration schedulerJobConfiguration = (SchedulerJobConfiguration)SchedulerEngineHelperImpl.this._bundleContext.getService(serviceReference);
            TriggerConfiguration triggerConfiguration = schedulerJobConfiguration.getTriggerConfiguration();
            Trigger trigger = null;
            trigger = Validator.isNotNull((String)triggerConfiguration.getCronExpression()) ? SchedulerEngineHelperImpl.this._triggerFactory.createTrigger(schedulerJobConfiguration.getName(), schedulerJobConfiguration.getName(), triggerConfiguration.getStartDate(), null, triggerConfiguration.getCronExpression()) : SchedulerEngineHelperImpl.this._triggerFactory.createTrigger(schedulerJobConfiguration.getName(), schedulerJobConfiguration.getName(), triggerConfiguration.getStartDate(), null, triggerConfiguration.getInterval(), triggerConfiguration.getTimeUnit());
            ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(false));
            try {
                SchedulerEngineHelperImpl.this.schedule(trigger, StorageType.MEMORY_CLUSTERED, null, schedulerJobConfiguration.getDestinationName(), null);
                SchedulerEngineHelperImpl.this._messageListenerServiceRegistrations.put(schedulerJobConfiguration.getName(), (ServiceRegistration<MessageListener>)SchedulerEngineHelperImpl.this._bundleContext.registerService(MessageListener.class, (Object)new SchedulerJobConfigurationMessageListener(schedulerJobConfiguration), (Dictionary)HashMapDictionaryBuilder.put((Object)"destination.name", (Object)schedulerJobConfiguration.getDestinationName()).build()));
                SchedulerJobConfiguration schedulerJobConfiguration2 = schedulerJobConfiguration;
                return schedulerJobConfiguration2;
            }
            catch (SchedulerException schedulerException) {
                _log.error((Throwable)schedulerException);
            }
            finally {
                ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(true));
            }
            return null;
        }

        public void modifiedService(ServiceReference<SchedulerJobConfiguration> serviceReference, SchedulerJobConfiguration schedulerJobConfiguration) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<SchedulerJobConfiguration> serviceReference, SchedulerJobConfiguration schedulerJobConfiguration) {
            SchedulerEngineHelperImpl.this._bundleContext.ungetService(serviceReference);
            ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(false));
            try {
                SchedulerEngineHelperImpl.this.delete(schedulerJobConfiguration.getName(), schedulerJobConfiguration.getName(), StorageType.MEMORY_CLUSTERED);
            }
            catch (SchedulerException schedulerException) {
                _log.error((Throwable)schedulerException);
            }
            finally {
                ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(true));
            }
            ServiceRegistration<MessageListener> messageListenerServiceRegistration = SchedulerEngineHelperImpl.this._messageListenerServiceRegistrations.remove(schedulerJobConfiguration.getName());
            messageListenerServiceRegistration.unregister();
        }
    }
}

