/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineAuditor;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.scheduler.internal.configuration.SchedulerEngineHelperConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.scheduler.internal.configuration.SchedulerEngineHelperConfiguration"}, enabled=false, service={SchedulerEngineAuditor.class})
public class SchedulerEngineAuditorImpl
implements SchedulerEngineAuditor {
    private static final Snapshot<AuditRouter> _auditRouterSnapshot = new Snapshot(SchedulerEngineAuditorImpl.class, AuditRouter.class, null, true);
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    private volatile SchedulerEngineHelperConfiguration _schedulerEngineHelperConfiguration;

    public void auditSchedulerJobs(Message message, TriggerState triggerState) throws SchedulerException {
        if (!this._clusterMasterExecutor.isMaster()) {
            return;
        }
        AuditRouter auditRouter = (AuditRouter)_auditRouterSnapshot.get();
        if (!this._schedulerEngineHelperConfiguration.auditSchedulerJobEnabled() || auditRouter == null) {
            return;
        }
        try {
            AuditMessage auditMessage = new AuditMessage("SCHEDULER", 0L, 0L, "", SchedulerEngine.class.getName(), "0", triggerState.toString(), new Date(), this._jsonFactory.createJSONObject(this._jsonFactory.serialize((Object)message)));
            auditMessage.setServerName(InetAddressUtil.getLocalHostName());
            auditMessage.setServerPort(this._portal.getPortalLocalPort(false));
            auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new SchedulerException((Throwable)exception);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._schedulerEngineHelperConfiguration = (SchedulerEngineHelperConfiguration)ConfigurableUtil.createConfigurable(SchedulerEngineHelperConfiguration.class, properties);
    }
}

