/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.internal.verify;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scheduler.internal.configuration.SchedulerEngineHelperConfiguration;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"verify.process.name=com.liferay.portal.scheduler.internal.verify"}, service={VerifyProcess.class})
public class SchedulerHelperPropertiesVerifyProcess
extends VerifyProcess {
    protected static final String AUDIT_SCHEDULER_JOB_ENABLED = "auditSchedulerJobEnabled";
    protected static final String LEGACY_AUDIT_MESSAGE_SCHEDULER_JOB = "audit.message.scheduler.job";
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected Props props;

    protected void doVerify() throws Exception {
        this.upgradeConfiguration();
    }

    protected void upgradeConfiguration() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String audiMessageScheduleJobString = this.props.get(LEGACY_AUDIT_MESSAGE_SCHEDULER_JOB);
            if (Validator.isNull((String)audiMessageScheduleJobString)) {
                return;
            }
            Configuration configuration = this.configurationAdmin.getConfiguration(SchedulerEngineHelperConfiguration.class.getName(), "?");
            HashMapDictionary properties = new HashMapDictionary();
            boolean auditMessageScheduleJob = GetterUtil.getBoolean((String)audiMessageScheduleJobString);
            properties.put(AUDIT_SCHEDULER_JOB_ENABLED, auditMessageScheduleJob);
            configuration.update((Dictionary)properties);
        }
    }
}

