/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.cal.RecurrenceSerializer;
import com.liferay.portal.kernel.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.StorageTypeAware;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scheduler.internal.configuration.SchedulerEngineHelperConfiguration;
import com.liferay.portal.scheduler.internal.messaging.config.ScriptingMessageListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.scheduler.configuration.SchedulerEngineHelperConfiguration"}, enabled=false, immediate=true, service={SchedulerEngineHelper.class})
public class SchedulerEngineHelperImpl
implements SchedulerEngineHelper {
    private static final Log _log = LogFactoryUtil.getLog(SchedulerEngineHelperImpl.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AuditRouter _auditRouter;
    private volatile BundleContext _bundleContext;
    private DestinationFactory _destinationFactory;
    private final Set<ServiceRegistration<Destination>> _destinationServiceRegistrations = new HashSet<ServiceRegistration<Destination>>();
    private JSONFactory _jsonFactory;
    private final Map<String, ServiceRegistration<MessageListener>> _messageListenerServiceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<MessageListener>>();
    @Reference
    private Portal _portal;
    private SchedulerEngine _schedulerEngine;
    private volatile SchedulerEngineHelperConfiguration _schedulerEngineHelperConfiguration;
    private final Map<String, ServiceRegistration<SchedulerEventMessageListener>> _serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<SchedulerEventMessageListener>>();
    private volatile ServiceTracker<SchedulerEventMessageListener, SchedulerEventMessageListener> _serviceTracker;

    public void addScriptingJob(Trigger trigger, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.put("LANGUAGE", (Object)language);
        message.put("SCRIPT", (Object)script);
        this.schedule(trigger, storageType, description, "liferay/scheduler_scripting", message, exceptionsMaxSize);
    }

    public void auditSchedulerJobs(Message message, TriggerState triggerState) throws SchedulerException {
        if (!this._schedulerEngineHelperConfiguration.auditSchedulerJobEnabled() || this._auditRouter == null) {
            return;
        }
        try {
            AuditMessage auditMessage = new AuditMessage("SCHEDULER", 0L, 0L, "", SchedulerEngine.class.getName(), "0", triggerState.toString(), new Date(), this._jsonFactory.createJSONObject(this._jsonFactory.serialize((Object)message)));
            auditMessage.setServerName(InetAddressUtil.getLocalHostName());
            auditMessage.setServerPort(this._portal.getPortalLocalPort(false));
            this._auditRouter.route(auditMessage);
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void delete(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this.delete(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    public void delete(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(groupName, storageType);
    }

    public void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(jobName, groupName, storageType);
    }

    public String getCronText(Calendar calendar, boolean timeZoneSensitive) {
        return this.getCronText(null, calendar, timeZoneSensitive, 7);
    }

    public String getCronText(PortletRequest portletRequest, Calendar calendar, boolean timeZoneSensitive, int recurrenceType) {
        Calendar recurrenceCalendar = null;
        if (timeZoneSensitive) {
            recurrenceCalendar = CalendarFactoryUtil.getCalendar();
            recurrenceCalendar.setTime(calendar.getTime());
        } else {
            recurrenceCalendar = (Calendar)calendar.clone();
        }
        Recurrence recurrence = new Recurrence(recurrenceCalendar, new Duration(1, 0, 0, 0), recurrenceType);
        recurrence.setWeekStart(1);
        if (recurrenceType == 3) {
            int dailyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyType");
            if (dailyType == 0) {
                int dailyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyInterval", (int)1);
                recurrence.setInterval(dailyInterval);
            } else {
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)};
                recurrence.setByDay(dayPos);
            }
        } else if (recurrenceType == 4) {
            int weeklyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"weeklyInterval");
            recurrence.setInterval(weeklyInterval);
            ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
            this.addWeeklyDayPos(portletRequest, dayPos, 1);
            this.addWeeklyDayPos(portletRequest, dayPos, 2);
            this.addWeeklyDayPos(portletRequest, dayPos, 3);
            this.addWeeklyDayPos(portletRequest, dayPos, 4);
            this.addWeeklyDayPos(portletRequest, dayPos, 5);
            this.addWeeklyDayPos(portletRequest, dayPos, 6);
            this.addWeeklyDayPos(portletRequest, dayPos, 7);
            if (dayPos.isEmpty()) {
                dayPos.add(new DayAndPosition(2, 0));
            }
            recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
        } else if (recurrenceType == 5) {
            int monthlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyType");
            if (monthlyType == 0) {
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay0", (int)1);
                recurrence.setByMonthDay(new int[]{monthlyDay});
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval0", (int)1);
                recurrence.setInterval(monthlyInterval);
            } else {
                int monthlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyPos");
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(monthlyDay, monthlyPos)};
                recurrence.setByDay(dayPos);
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval1", (int)1);
                recurrence.setInterval(monthlyInterval);
            }
        } else if (recurrenceType == 6) {
            int yearlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyType");
            if (yearlyType == 0) {
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth0");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay0", (int)1);
                recurrence.setByMonth(new int[]{yearlyMonth});
                recurrence.setByMonthDay(new int[]{yearlyDay});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval0", (int)1);
                recurrence.setInterval(yearlyInterval);
            } else {
                int yearlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyPos");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay1");
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(yearlyDay, yearlyPos)};
                recurrence.setByDay(dayPos);
                recurrence.setByMonth(new int[]{yearlyMonth});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval1", (int)1);
                recurrence.setInterval(yearlyInterval);
            }
        }
        return RecurrenceSerializer.toCronText((Recurrence)recurrence);
    }

    public Date getEndTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("END_TIME");
        }
        return jobState.getTriggerDate("END_TIME");
    }

    public Date getEndTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getEndTime(schedulerResponse);
        }
        return null;
    }

    public Date getFinalFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("FINAL_FIRE_TIME");
        }
        return jobState.getTriggerDate("FINAL_FIRE_TIME");
    }

    public Date getFinalFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getFinalFireTime(schedulerResponse);
        }
        return null;
    }

    public ObjectValuePair<Exception, Date>[] getJobExceptions(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getExceptions();
    }

    public ObjectValuePair<Exception, Date>[] getJobExceptions(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getJobExceptions(schedulerResponse);
        }
        return null;
    }

    public TriggerState getJobState(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getTriggerState();
    }

    public TriggerState getJobState(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getJobState(schedulerResponse);
        }
        return null;
    }

    public Date getNextFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("NEXT_FIRE_TIME");
        }
        return jobState.getTriggerDate("NEXT_FIRE_TIME");
    }

    public Date getNextFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getNextFireTime(schedulerResponse);
        }
        return null;
    }

    public Date getPreviousFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("PREVIOUS_FIRE_TIME");
        }
        return jobState.getTriggerDate("PREVIOUS_FIRE_TIME");
    }

    public Date getPreviousFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getPreviousFireTime(schedulerResponse);
        }
        return null;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJob(jobName, groupName, storageType);
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs();
    }

    public List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(storageType);
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(groupName, storageType);
    }

    public Date getStartTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("START_TIME");
        }
        return jobState.getTriggerDate("START_TIME");
    }

    public Date getStartTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getStartTime(schedulerResponse);
        }
        return null;
    }

    public void pause(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(groupName, storageType);
    }

    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(jobName, groupName, storageType);
    }

    public void register(MessageListener messageListener, SchedulerEntry schedulerEntry, String destinationName) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", destinationName);
        Class<?> messageListenerClass = messageListener.getClass();
        ServiceRegistration serviceRegistration = this._serviceRegistrations.get(messageListenerClass.getName());
        if (serviceRegistration != null) {
            SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = (SchedulerEventMessageListenerWrapper)this._bundleContext.getService(serviceRegistration.getReference());
            schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
            serviceRegistration.setProperties((Dictionary)properties);
            return;
        }
        SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
        schedulerEventMessageListenerWrapper.setMessageListener(messageListener);
        schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
        serviceRegistration = this._bundleContext.registerService(SchedulerEventMessageListener.class, (Object)schedulerEventMessageListenerWrapper, (Dictionary)properties);
        this._serviceRegistrations.put(messageListenerClass.getName(), (ServiceRegistration<SchedulerEventMessageListener>)serviceRegistration);
    }

    public void resume(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(groupName, storageType);
    }

    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(jobName, groupName, storageType);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Message message, int exceptionsMaxSize) throws SchedulerException {
        this._schedulerEngine.validateTrigger(trigger, storageType);
        if (message == null) {
            message = new Message();
        }
        message.put("EXCEPTIONS_MAX_SIZE", (Object)exceptionsMaxSize);
        this._schedulerEngine.schedule(trigger, description, destinationName, message, storageType);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        this.schedule(trigger, storageType, description, destinationName, message, exceptionsMaxSize);
    }

    public void shutdown() throws SchedulerException {
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    public void suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.suppressError(jobName, groupName, storageType);
    }

    public void unregister(MessageListener messageListener) {
        Class<?> messageListenerClass = messageListener.getClass();
        this._serviceRegistrations.compute(messageListenerClass.getName(), (key, value) -> {
            value.unregister();
            return null;
        });
    }

    public void unschedule(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this.unschedule(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    public void unschedule(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.unschedule(groupName, storageType);
    }

    public void unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.unschedule(jobName, groupName, storageType);
    }

    public void update(String jobName, String groupName, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse == null) {
            return;
        }
        Trigger trigger = schedulerResponse.getTrigger();
        if (trigger == null) {
            return;
        }
        Message message = schedulerResponse.getMessage();
        if (message == null) {
            return;
        }
        this.addScriptingJob(trigger, storageType, description, language, script, exceptionsMaxSize);
    }

    public void update(Trigger trigger, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.update(trigger, storageType);
    }

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        Dictionary properties = componentContext.getProperties();
        this._schedulerEngineHelperConfiguration = (SchedulerEngineHelperConfiguration)ConfigurableUtil.createConfigurable(SchedulerEngineHelperConfiguration.class, (Dictionary)properties);
        this._bundleContext = componentContext.getBundleContext();
        this.registerDestination(this._bundleContext, "parallel", "liferay/scheduler_dispatch");
        Destination scriptingDestination = this.registerDestination(this._bundleContext, "parallel", "liferay/scheduler_scripting");
        SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
        schedulerEventMessageListenerWrapper.setMessageListener((MessageListener)new ScriptingMessageListener());
        scriptingDestination.register((MessageListener)schedulerEventMessageListenerWrapper);
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)("(objectClass=" + SchedulerEventMessageListener.class.getName() + ")"), (ServiceTrackerCustomizer)new SchedulerEventMessageListenerServiceTrackerCustomizer());
    }

    protected void addWeeklyDayPos(PortletRequest portletRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("weeklyDayPos" + day))) {
            list.add(new DayAndPosition(day, 0));
        }
    }

    @Deactivate
    protected void deactivate() {
        block6: {
            if (this._bundleContext == null) {
                return;
            }
            if (this._serviceTracker != null) {
                this._serviceTracker.close();
            }
            try {
                this.shutdown();
            }
            catch (SchedulerException se) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)"Unable to shutdown scheduler", (Throwable)se);
            }
        }
        for (ServiceRegistration<Destination> serviceRegistration : this._destinationServiceRegistrations) {
            Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            destination.destroy();
        }
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._bundleContext = null;
    }

    protected SchedulerEngine getSchedulerEngine() {
        return this._schedulerEngine;
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws Exception {
        this._schedulerEngineHelperConfiguration = (SchedulerEngineHelperConfiguration)ConfigurableUtil.createConfigurable(SchedulerEngineHelperConfiguration.class, properties);
    }

    protected Destination registerDestination(BundleContext bundleContext, String destinationType, String destinationName) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration(destinationType, destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("destination.name", destination.getName());
        ServiceRegistration serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
        this._destinationServiceRegistrations.add((ServiceRegistration<Destination>)serviceRegistration);
        return destination;
    }

    @Reference(unbind="-")
    protected void setDestinationFactory(DestinationFactory destinationFactory) {
        this._destinationFactory = destinationFactory;
    }

    @Reference(target="(&(destination.name=liferay/scheduler_engine)(destination.ready=true))", unbind="-")
    protected void setDestinationReady(Object object) {
    }

    @Reference(unbind="-")
    protected void setJsonFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    @Reference(target="(scheduler.engine.proxy=true)", unbind="-")
    protected void setSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    private class SchedulerEventMessageListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SchedulerEventMessageListener, SchedulerEventMessageListener> {
        private SchedulerEventMessageListenerServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SchedulerEventMessageListener addingService(ServiceReference<SchedulerEventMessageListener> serviceReference) {
            String destinationName;
            Bundle bundle = serviceReference.getBundle();
            BundleContext bundleContext = bundle.getBundleContext();
            SchedulerEventMessageListener schedulerEventMessageListener = (SchedulerEventMessageListener)bundleContext.getService(serviceReference);
            SchedulerEntry schedulerEntry = schedulerEventMessageListener.getSchedulerEntry();
            if (schedulerEntry == null || schedulerEntry.getTrigger() == null) {
                return null;
            }
            StorageType storageType = StorageType.MEMORY_CLUSTERED;
            if (schedulerEntry instanceof StorageTypeAware) {
                StorageTypeAware storageTypeAware = (StorageTypeAware)schedulerEntry;
                storageType = storageTypeAware.getStorageType();
            }
            if (Validator.isNull((String)(destinationName = (String)serviceReference.getProperty("destination.name")))) {
                destinationName = "liferay/scheduler_dispatch";
            }
            ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(false));
            try {
                SchedulerEngineHelperImpl.this.schedule(schedulerEntry.getTrigger(), storageType, schedulerEntry.getDescription(), destinationName, null, 0);
                ServiceRegistration serviceRegistration = (ServiceRegistration)SchedulerEngineHelperImpl.this._messageListenerServiceRegistrations.get(schedulerEntry.getEventListenerClass());
                if (serviceRegistration != null) {
                    ServiceReference oldServiceReference = serviceRegistration.getReference();
                    MessageListener messageListener = (MessageListener)bundleContext.getService(oldServiceReference);
                    SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = (SchedulerEventMessageListenerWrapper)messageListener;
                    schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
                    SchedulerEventMessageListener schedulerEventMessageListener2 = null;
                    return schedulerEventMessageListener2;
                }
                HashMapDictionary properties = new HashMapDictionary();
                properties.put("destination.name", destinationName);
                serviceRegistration = bundleContext.registerService(MessageListener.class, (Object)schedulerEventMessageListener, (Dictionary)properties);
                SchedulerEngineHelperImpl.this._messageListenerServiceRegistrations.put(schedulerEntry.getEventListenerClass(), serviceRegistration);
                SchedulerEventMessageListener schedulerEventMessageListener3 = schedulerEventMessageListener;
                return schedulerEventMessageListener3;
            }
            catch (SchedulerException se) {
                _log.error((Object)se, (Throwable)se);
            }
            finally {
                ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(true));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<SchedulerEventMessageListener> serviceReference, SchedulerEventMessageListener schedulerEventMessageListener) {
            SchedulerEntry schedulerEntry = schedulerEventMessageListener.getSchedulerEntry();
            if (schedulerEntry == null || schedulerEntry.getTrigger() == null) {
                return;
            }
            StorageType storageType = StorageType.MEMORY_CLUSTERED;
            if (schedulerEntry instanceof StorageTypeAware) {
                StorageTypeAware storageTypeAware = (StorageTypeAware)schedulerEntry;
                storageType = storageTypeAware.getStorageType();
            }
            ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(false));
            try {
                SchedulerEngineHelperImpl.this.update(schedulerEntry.getTrigger(), storageType);
            }
            catch (SchedulerException se) {
                _log.error((Object)se, (Throwable)se);
            }
            finally {
                ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(true));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<SchedulerEventMessageListener> serviceReference, SchedulerEventMessageListener schedulerEntryMessageListener) {
            Bundle bundle = serviceReference.getBundle();
            BundleContext bundleContext = bundle.getBundleContext();
            bundleContext.ungetService(serviceReference);
            SchedulerEntry schedulerEntry = schedulerEntryMessageListener.getSchedulerEntry();
            if (schedulerEntry == null) {
                return;
            }
            StorageType storageType = StorageType.MEMORY_CLUSTERED;
            if (schedulerEntry instanceof StorageTypeAware) {
                StorageTypeAware storageTypeAware = (StorageTypeAware)schedulerEntry;
                storageType = storageTypeAware.getStorageType();
            }
            ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(false));
            try {
                SchedulerEngineHelperImpl.this.delete(schedulerEntry, storageType);
            }
            catch (SchedulerException se) {
                _log.error((Object)se, (Throwable)se);
            }
            finally {
                ClusterableContextThreadLocal.putThreadLocalContext((String)"scheduler.cluster.invoking", (Serializable)Boolean.valueOf(true));
            }
            ServiceRegistration messageListenerServiceRegistration = (ServiceRegistration)SchedulerEngineHelperImpl.this._messageListenerServiceRegistrations.remove(schedulerEntry.getEventListenerClass());
            messageListenerServiceRegistration.unregister();
        }
    }
}

