/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.rest.extender.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;

public class CXFJaxRsServiceRegistrator {
    private final Collection<Application> _applications = new ArrayList<Application>();
    private final Collection<Bus> _buses = new ArrayList<Bus>();
    private final Map<Bus, Map<Object, Server>> _busServers = new IdentityHashMap<Bus, Map<Object, Server>>();
    private final Map<String, Object> _properties;
    private final Collection<Object> _providers = new ArrayList<Object>();
    private final Collection<Object> _services = new ArrayList<Object>();

    public CXFJaxRsServiceRegistrator(Map<String, Object> properties) {
        this._properties = properties;
    }

    public synchronized void addApplication(Application application) {
        this._swapClassLoader(application, this::_addApplication);
    }

    public synchronized void addBus(Bus bus) {
        this._swapClassLoader(bus, this::_addBus);
    }

    public synchronized void addProvider(Object provider) {
        this._swapClassLoader(provider, this::_addProvider);
    }

    public synchronized void addService(Object service) {
        this._swapClassLoader(service, this::_addService);
    }

    public synchronized void removeApplication(Application application) {
        this._swapClassLoader(application, this::_removeApplication);
    }

    public synchronized void removeBus(Bus bus) {
        this._swapClassLoader(bus, this::_removeBus);
    }

    public synchronized void removeProvider(Object provider) {
        this._swapClassLoader(provider, this::_removeProvider);
    }

    public synchronized void removeService(Object service) {
        this._swapClassLoader(service, this::_removeService);
    }

    protected void registerApplication(Bus bus, Application application) {
        RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean jaxRSServerFactoryBean = (JAXRSServerFactoryBean)runtimeDelegate.createEndpoint(application, JAXRSServerFactoryBean.class);
        jaxRSServerFactoryBean.setBus(bus);
        jaxRSServerFactoryBean.setProperties(this._properties);
        JSONProvider jsonProvider = new JSONProvider();
        jsonProvider.setDropCollectionWrapperElement(true);
        jsonProvider.setDropRootElement(true);
        jsonProvider.setSerializeAsArray(true);
        jsonProvider.setSupportUnwrapped(true);
        jaxRSServerFactoryBean.setProvider((Object)jsonProvider);
        for (Object provider : this._providers) {
            jaxRSServerFactoryBean.setProvider(provider);
        }
        for (Object service : this._services) {
            jaxRSServerFactoryBean.setServiceBean(service);
        }
        Server server = jaxRSServerFactoryBean.create();
        server.start();
        this.store(bus, application, server);
    }

    protected void registerApplications() {
        for (Bus bus : this._buses) {
            for (Application application : this._applications) {
                this.registerApplication(bus, application);
            }
        }
    }

    protected void remove(Object application) {
        for (Map<Object, Server> servers : this._busServers.values()) {
            Server server = servers.remove(application);
            if (server == null) continue;
            server.destroy();
        }
    }

    protected void rewire() {
        for (Application application : this._applications) {
            this.remove(application);
        }
        this.registerApplications();
    }

    protected void store(Bus bus, Object object, Server server) {
        Map<Object, Server> servers = this._busServers.get(bus);
        if (servers == null) {
            servers = new HashMap<Object, Server>();
            this._busServers.put(bus, servers);
        }
        servers.put(object, server);
    }

    private void _addApplication(Application application) {
        this._applications.add(application);
        this.rewire();
    }

    private void _addBus(Bus bus) {
        this._buses.add(bus);
        for (Application application : this._applications) {
            this.registerApplication(bus, application);
        }
    }

    private void _addProvider(Object provider) {
        this._providers.add(provider);
        this.rewire();
    }

    private void _addService(Object service) {
        this._services.add(service);
        this.rewire();
    }

    private void _removeApplication(Application application) {
        this._applications.remove(application);
        this.remove(application);
    }

    private void _removeBus(Bus bus) {
        this._buses.remove(bus);
        Map<Object, Server> servers = this._busServers.remove(bus);
        if (servers == null) {
            return;
        }
        for (Server server : servers.values()) {
            server.destroy();
        }
    }

    private void _removeProvider(Object provider) {
        this._providers.remove(provider);
        this.rewire();
    }

    private void _removeService(Object service) {
        this._services.remove(service);
        this.rewire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void _swapClassLoader(T t, Consumer<T> consumer) {
        Class<?> clazz = t.getClass();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(clazz.getClassLoader());
            consumer.accept(t);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }
}

