/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.internal.servlet.filter;

import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.remote.jaxrs.whiteboard.internal.servlet.filter.JAXRSActivationFilter;
import com.liferay.portal.remote.jaxrs.whiteboard.lifecycle.JAXRSLifecycle;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import java.util.Dictionary;
import java.util.concurrent.CountDownLatch;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class JAXRSActivationFilterTracker {
    private CountDownLatch _countDownLatch;
    private ServiceRegistration<Filter> _filterServiceRegistration;
    @Reference
    private JAXRSLifecycle _jaxrsLifecycle;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._countDownLatch = new CountDownLatch(1);
        this._filterServiceRegistration = bundleContext.registerService(Filter.class, (Object)new JAXRSActivationFilter(bundleContext, this), (Dictionary)HashMapDictionaryBuilder.put((Object)"dispatcher", (Object)new String[]{"FORWARD", "INCLUDE", "REQUEST"}).put((Object)"servlet-context-name", (Object)"").put((Object)"servlet-filter-name", (Object)"Activation Filter").put((Object)"url-pattern", (Object)"/o/*").build());
        this._countDownLatch.countDown();
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._unregister();
    }

    protected synchronized void setReady() throws ServletException {
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new ServletException((Throwable)interruptedException);
        }
        this._jaxrsLifecycle.ensureReady();
        this._unregister();
    }

    private void _unregister() {
        if (this._filterServiceRegistration != null) {
            this._filterServiceRegistration.unregister();
            this._filterServiceRegistration = null;
        }
    }
}

