/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.http.tunnel.extender.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.remote.http.tunnel.extender.configuration.HttpTunnelExtenderConfiguration;
import com.liferay.portal.servlet.TunnelServlet;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.remote.http.tunnel.extender.configuration.HttpTunnelExtenderConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={})
public class HttpTunnelExtender
implements BundleTrackerCustomizer<TunnelServletExtension> {
    private BundleTracker<?> _bundleTracker;
    private HttpTunnelExtenderConfiguration _httpTunnelExtenderConfiguration;

    public TunnelServletExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Http-Tunnel") == null) {
            return null;
        }
        TunnelServletExtension tunnelServletExtension = new TunnelServletExtension(bundle);
        tunnelServletExtension.start();
        return tunnelServletExtension;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, TunnelServletExtension tunnelServletExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, TunnelServletExtension tunnelServletExtension) {
        tunnelServletExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._httpTunnelExtenderConfiguration = (HttpTunnelExtenderConfiguration)ConfigurableUtil.createConfigurable(HttpTunnelExtenderConfiguration.class, properties);
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }

    private final class ServiceRegistrations {
        private final ServiceRegistration<Filter> _authVerifierFilterServiceRegistration;
        private final ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
        private final ServiceRegistration<Servlet> _tunnelServletServiceRegistration;

        public ServiceRegistrations(ServiceRegistration<Filter> authVerifierFilterServiceRegistration, ServiceRegistration<ServletContextHelper> servletContextHelperServiceRegistration, ServiceRegistration<Servlet> tunneServletServiceRegistration) {
            this._authVerifierFilterServiceRegistration = authVerifierFilterServiceRegistration;
            this._servletContextHelperServiceRegistration = servletContextHelperServiceRegistration;
            this._tunnelServletServiceRegistration = tunneServletServiceRegistration;
        }
    }

    public class TunnelServletExtension {
        private final Bundle _bundle;
        private ServiceRegistrations _serviceRegistrations;

        public TunnelServletExtension(Bundle bundle) {
            this._bundle = bundle;
        }

        public void destroy() {
            ServiceRegistration authVerifierFilterServiceRegistration = this._serviceRegistrations._authVerifierFilterServiceRegistration;
            authVerifierFilterServiceRegistration.unregister();
            ServiceRegistration servletContextHelperServiceRegistration = this._serviceRegistrations._servletContextHelperServiceRegistration;
            servletContextHelperServiceRegistration.unregister();
            ServiceRegistration tunnelServletServiceRegistration = this._serviceRegistrations._tunnelServletServiceRegistration;
            tunnelServletServiceRegistration.unregister();
        }

        public void start() {
            BundleContext bundleContext = this._bundle.getBundleContext();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("filter.init.auth.verifier.TunnelingServletAuthVerifier.hosts.allowed", StringUtil.merge((Object[])HttpTunnelExtender.this._httpTunnelExtenderConfiguration.hostsAllowed()));
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", AuthVerifierFilter.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.pattern", "/api/liferay/do");
            ServiceRegistration authVerifierFilterServiceRegistration = bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.name", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/" + this._bundle.getSymbolicName());
            ServiceRegistration servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(this._bundle){

                public URL getResource(String name) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    return TunnelServletExtension.this._bundle.getResource(name);
                }
            }, properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", TunnelServlet.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/api/liferay/do");
            ((Dictionary)properties).put("servlet.init.httpMethods", "POST");
            ServiceRegistration tunnelServletServiceRegistration = bundleContext.registerService(Servlet.class, (Object)new TunnelServlet(), properties);
            this._serviceRegistrations = new ServiceRegistrations((ServiceRegistration<Filter>)authVerifierFilterServiceRegistration, (ServiceRegistration<ServletContextHelper>)servletContextHelperServiceRegistration, (ServiceRegistration<Servlet>)tunnelServletServiceRegistration);
        }
    }
}

