/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.http.tunnel.extender.internal;

import com.liferay.osgi.felix.util.AbstractExtender;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.remote.http.tunnel.extender.configuration.HttpTunnelExtenderConfiguration;
import com.liferay.portal.servlet.TunnelServlet;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.http.context.ServletContextHelper;

@Component(configurationPid={"com.liferay.portal.remote.http.tunnel.extender.configuration.HttpTunnelExtenderConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={})
public class HttpTunnelExtender
extends AbstractExtender {
    private HttpTunnelExtenderConfiguration _httpTunnelExtenderConfiguration;
    private Logger _logger;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this._httpTunnelExtenderConfiguration = (HttpTunnelExtenderConfiguration)ConfigurableUtil.createConfigurable(HttpTunnelExtenderConfiguration.class, properties);
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this.stop(bundleContext);
    }

    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}));
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Http-Tunnel") == null) {
            return null;
        }
        return new TunnelServletExtension(bundle);
    }

    protected void error(String s, Throwable t) {
        this._logger.log(1, s, t);
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this.deactivate(bundleContext);
        this.activate(bundleContext, properties);
    }

    protected void warn(Bundle bundle, String s, Throwable t) {
        this._logger.log(2, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}), t);
    }

    private class TunnelServletExtension
    implements Extension {
        private final Bundle _bundle;
        private ServiceRegistrations _serviceRegistrations;

        public TunnelServletExtension(Bundle bundle) {
            this._bundle = bundle;
        }

        public void destroy() throws Exception {
            ServiceRegistration authVerifierFilterServiceRegistration = this._serviceRegistrations._authVerifierFilterServiceRegistration;
            authVerifierFilterServiceRegistration.unregister();
            ServiceRegistration servletContextHelperServiceRegistration = this._serviceRegistrations._servletContextHelperServiceRegistration;
            servletContextHelperServiceRegistration.unregister();
            ServiceRegistration tunnelServletServiceRegistration = this._serviceRegistrations._tunnelServletServiceRegistration;
            tunnelServletServiceRegistration.unregister();
        }

        public void start() throws Exception {
            BundleContext bundleContext = this._bundle.getBundleContext();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("filter.init.auth.verifier.TunnelingServletAuthVerifier.hosts.allowed", StringUtil.merge((Object[])HttpTunnelExtender.this._httpTunnelExtenderConfiguration.hostsAllowed()));
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", AuthVerifierFilter.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.pattern", "/api/liferay/do");
            ServiceRegistration authVerifierFilterServiceRegistration = bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.name", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/" + this._bundle.getSymbolicName());
            ServiceRegistration servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(this._bundle){

                public URL getResource(String name) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    return TunnelServletExtension.this._bundle.getResource(name);
                }
            }, properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.http.tunnel." + this._bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", TunnelServlet.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/api/liferay/do");
            ((Dictionary)properties).put("servlet.init.httpMethods", "POST");
            ServiceRegistration tunnelServletServiceRegistration = bundleContext.registerService(Servlet.class, (Object)new TunnelServlet(), properties);
            this._serviceRegistrations = new ServiceRegistrations((ServiceRegistration<Filter>)authVerifierFilterServiceRegistration, (ServiceRegistration<ServletContextHelper>)servletContextHelperServiceRegistration, (ServiceRegistration<Servlet>)tunnelServletServiceRegistration);
        }
    }

    private final class ServiceRegistrations {
        private final ServiceRegistration<Filter> _authVerifierFilterServiceRegistration;
        private final ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
        private final ServiceRegistration<Servlet> _tunnelServletServiceRegistration;

        public ServiceRegistrations(ServiceRegistration<Filter> authVerifierFilterServiceRegistration, ServiceRegistration<ServletContextHelper> servletContextHelperServiceRegistration, ServiceRegistration<Servlet> tunneServletServiceRegistration) {
            this._authVerifierFilterServiceRegistration = authVerifierFilterServiceRegistration;
            this._servletContextHelperServiceRegistration = servletContextHelperServiceRegistration;
            this._tunnelServletServiceRegistration = tunneServletServiceRegistration;
        }
    }
}

