/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.axis;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.axis.SimpleAuthenticator;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPSender;

public class SimpleHTTPSender
extends HTTPSender {
    private static final Log _log = LogFactoryUtil.getLog(SimpleHTTPSender.class);
    private final String _urlPattern;

    public SimpleHTTPSender() {
        String urlPattern = SystemProperties.get((String)(SimpleHTTPSender.class.getName() + ".url.pattern"));
        this._urlPattern = Validator.isNotNull((String)urlPattern) ? urlPattern : null;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        String url = messageContext.getStrProp("transport.url");
        if (this._urlPattern != null && StringUtil.wildcardMatches((String)url, (String)this._urlPattern, (char)'?', (char)'*', (char)'%', (boolean)false)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("A match was found for " + url));
            }
            this._invoke(messageContext, url);
        } else {
            super.invoke(messageContext);
        }
    }

    private void _invoke(MessageContext messageContext, String url) throws AxisFault {
        try {
            String userName = messageContext.getUsername();
            String password = messageContext.getPassword();
            if (userName != null && password != null) {
                Authenticator.setDefault(new SimpleAuthenticator(userName, password));
            }
            URL urlObj = new URL(url);
            URLConnection urlConnection = urlObj.openConnection();
            this._writeToConnection(urlConnection, messageContext);
            this._readFromConnection(urlConnection, messageContext);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        finally {
            Authenticator.setDefault(null);
        }
    }

    private void _readFromConnection(URLConnection urlConnection, MessageContext messageContext) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = urlConnection.getInputStream();
        }
        inputStream = new UnsyncBufferedInputStream(inputStream, 8192);
        String contentType = urlConnection.getContentType();
        String contentLocation = urlConnection.getHeaderField("Content-Location");
        Message message = new Message((Object)inputStream, false, contentType, contentLocation);
        message.setMessageType("response");
        messageContext.setResponseMessage(message);
    }

    private void _writeToConnection(URLConnection urlConnection, MessageContext messageContext) throws Exception {
        urlConnection.setDoOutput(true);
        Message message = messageContext.getRequestMessage();
        String contentType = message.getContentType(messageContext.getSOAPConstants());
        urlConnection.setRequestProperty("Content-Type", contentType);
        if (messageContext.useSOAPAction()) {
            urlConnection.setRequestProperty("SOAPAction", messageContext.getSOAPActionURI());
        }
        UnsyncBufferedOutputStream outputStream = new UnsyncBufferedOutputStream(urlConnection.getOutputStream(), 8192);
        message.writeTo((OutputStream)outputStream);
        outputStream.flush();
    }
}

