/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.properties.swapper.internal;

import com.liferay.osgi.util.configuration.ConfigurationPersistenceUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsValues;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={PortalInstanceLifecycleListener.class})
public class SwapDefaultGuestGroupLogoPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private long _defaultCompanyId;
    @Reference
    private GroupLocalService _groupLocalService;
    private long _lastModifiedTime;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (company.getCompanyId() != this._defaultCompanyId) {
            return;
        }
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
        if (layoutSet.getLogoId() != 0L) {
            return;
        }
        Bundle bundle = FrameworkUtil.getBundle(SwapDefaultGuestGroupLogoPortalInstanceLifecycleListener.class);
        URL url = bundle.getResource("com/liferay/portal/properties/swapper/internal/default_guest_group_logo.png");
        try (InputStream inputStream = url.openStream();){
            this._layoutSetLocalService.updateLogo(group.getGroupId(), false, true, inputStream);
        }
    }

    @Activate
    protected void activate() throws Exception {
        this._lastModifiedTime = ConfigurationPersistenceUtil.update((Object)((Object)this), Collections.singletonMap("company.default.web.id", PropsValues.COMPANY_DEFAULT_WEB_ID));
        this._defaultCompanyId = this._portal.getDefaultCompanyId();
    }
}

