/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop.notifications.internal.scheduler;

import com.liferay.mail.kernel.service.MailService;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.pop.notifications.internal.MessageListenerWrapper;
import com.liferay.portal.util.PropsValues;
import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={SchedulerJobConfiguration.class})
public class POPNotificationsSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(POPNotificationsSchedulerJobConfiguration.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private MailService _mailService;
    private ServiceTrackerList<MessageListenerWrapper> _messageListenerWrappers;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> this._companyLocalService.forEachCompanyId(companyId -> {
            if (!PrefsPropsUtil.getBoolean((long)companyId, (String)"pop.server.notifications.enabled", (boolean)PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED)) {
                return;
            }
            this._popNotifications((long)companyId);
        });
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)1, (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._messageListenerWrappers = ServiceTrackerListFactory.open((BundleContext)bundleContext, MessageListener.class, null, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MessageListener, MessageListenerWrapper>(){

            public MessageListenerWrapper addingService(ServiceReference<MessageListener> serviceReference) {
                return new MessageListenerWrapper((MessageListener)bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<MessageListener> serviceReference, MessageListenerWrapper messageListenerWrapper) {
            }

            public void removedService(ServiceReference<MessageListener> serviceReference, MessageListenerWrapper sessageListenerWrapper) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._messageListenerWrappers.close();
    }

    private String _getEmailAddress(Address[] addresses) {
        if (ArrayUtil.isEmpty((Object[])addresses)) {
            return "";
        }
        InternetAddress internetAddress = (InternetAddress)addresses[0];
        return internetAddress.getAddress();
    }

    private List<String> _getEmailAddresses(Address[] addresses) {
        if (ArrayUtil.isEmpty((Object[])addresses)) {
            return new ArrayList<String>();
        }
        ArrayList<String> emailAddresses = new ArrayList<String>();
        for (Address address : addresses) {
            InternetAddress internetAddress = (InternetAddress)address;
            emailAddresses.add(internetAddress.getAddress());
        }
        return emailAddresses;
    }

    private Folder _getInboxFolder(Store store) throws MessagingException {
        Folder defaultFolder = store.getDefaultFolder();
        Folder[] folders = defaultFolder.list();
        if (folders.length == 0) {
            throw new MessagingException("Inbox not found");
        }
        Folder inboxFolder = folders[0];
        inboxFolder.open(2);
        return inboxFolder;
    }

    private Store _getStore(long companyId) throws MessagingException {
        String password;
        Session session = this._mailService.getSession(companyId);
        String storeProtocol = GetterUtil.getString((String)session.getProperty("mail.store.protocol"));
        if (!storeProtocol.equals("pop3s")) {
            storeProtocol = "pop3";
        }
        Store store = session.getStore(storeProtocol);
        String prefix = "mail." + storeProtocol + ".";
        String host = session.getProperty(prefix + "host");
        String user = session.getProperty(prefix + "user");
        if (Validator.isNull((String)user)) {
            user = session.getProperty("mail.smtp.user");
        }
        if (Validator.isNull((String)(password = session.getProperty(prefix + "password")))) {
            password = session.getProperty("mail.smtp.password");
        }
        store.connect(host, user, password);
        return store;
    }

    private void _notifyMessageListeners(Message[] messages) throws MessagingException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Messages " + messages.length));
        }
        for (Message message : messages) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + String.valueOf(message)));
            }
            String from = this._getEmailAddress(message.getFrom());
            List<String> recipients = this._getEmailAddresses(message.getRecipients(Message.RecipientType.TO));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("From " + from));
                _log.debug((Object)("Recipients " + recipients.toString()));
            }
            for (MessageListener messageListener : this._messageListenerWrappers) {
                try {
                    if (!messageListener.accept(from, recipients, message)) continue;
                    messageListener.deliver(from, recipients, message);
                }
                catch (MessageListenerException messageListenerException) {
                    _log.error((Throwable)messageListenerException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _popNotifications(long companyId) throws MessagingException {
        try (Store store = null;){
            store = this._getStore(companyId);
            Folder inboxFolder = this._getInboxFolder(store);
            if (inboxFolder == null) {
                return;
            }
            try {
                Message[] messages = inboxFolder.getMessages();
                if (messages == null) {
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting messages");
                }
                inboxFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                this._notifyMessageListeners(messages);
            }
            finally {
                inboxFolder.close(true);
            }
        }
    }
}

