/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop.notifications.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.ClassUtil;
import jakarta.mail.Message;
import java.util.List;
import java.util.Objects;

public class MessageListenerWrapper
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MessageListenerWrapper.class);
    private final MessageListener _messageListener;

    public MessageListenerWrapper(MessageListener messageListener) {
        this._messageListener = messageListener;
    }

    public boolean accept(String from, List<String> recipients, Message message) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listener " + ClassUtil.getClassName((Object)this._messageListener)));
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipients " + recipients.toString()));
        }
        boolean value = this._messageListener.accept(from, recipients, message);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Accept " + value));
        }
        return value;
    }

    public void deliver(String from, List<String> recipients, Message message) throws MessageListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listener " + ClassUtil.getClassName((Object)this._messageListener)));
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipients " + recipients.toString()));
            _log.debug((Object)("Message " + String.valueOf(message)));
        }
        this._messageListener.deliver(from, recipients, message);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageListenerWrapper)) {
            return false;
        }
        MessageListenerWrapper messageListener = (MessageListenerWrapper)object;
        return Objects.equals(this.getId(), messageListener.getId());
    }

    public String getId() {
        return this._messageListener.getId();
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public int hashCode() {
        String id = this._messageListener.getId();
        return id.hashCode();
    }
}

