/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.service;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.monitoring.DataSampleFactory;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.kernel.monitoring.ServiceMonitoringControl;
import com.liferay.portal.monitoring.internal.aop.ServiceMonitorAdvice;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, service={ServiceMonitoringControl.class})
public class ServiceMonitoringControlImpl
implements ServiceMonitoringControl {
    private volatile BundleContext _bundleContext;
    @Reference
    private DataSampleFactory _dataSampleFactory;
    private boolean _inclusiveMode = true;
    private volatile boolean _monitorServiceRequest;
    private final Set<String> _serviceClasses = new HashSet<String>();
    private final Set<MethodSignature> _serviceClassMethods = new HashSet<MethodSignature>();
    private volatile ServiceRegistration<ChainableMethodAdvice> _serviceRegistration;

    public void addServiceClass(String className) {
        this._serviceClasses.add(className);
    }

    public void addServiceClassMethod(String className, String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(className, methodName, parameterTypes);
        this._serviceClassMethods.add(methodSignature);
    }

    public Set<String> getServiceClasses() {
        return Collections.unmodifiableSet(this._serviceClasses);
    }

    public Set<MethodSignature> getServiceClassMethods() {
        return Collections.unmodifiableSet(this._serviceClassMethods);
    }

    public boolean isInclusiveMode() {
        return this._inclusiveMode;
    }

    public void setInclusiveMode(boolean inclusiveMode) {
        this._inclusiveMode = inclusiveMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, String> properties) {
        this._bundleContext = bundleContext;
        MonitoringConfiguration monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
        boolean monitorServiceRequest = monitoringConfiguration.monitorServiceRequest();
        if (monitorServiceRequest == this._monitorServiceRequest) {
            return;
        }
        ServiceMonitoringControlImpl serviceMonitoringControlImpl = this;
        synchronized (serviceMonitoringControlImpl) {
            if (monitorServiceRequest == this._monitorServiceRequest) {
                return;
            }
            if (this._serviceRegistration == null) {
                this._serviceRegistration = this._bundleContext.registerService(ChainableMethodAdvice.class, (Object)new ServiceMonitorAdvice(this, this._dataSampleFactory), null);
            } else {
                this._serviceRegistration.unregister();
                this._serviceRegistration = null;
            }
            this._monitorServiceRequest = monitorServiceRequest;
        }
    }

    @Deactivate
    protected synchronized void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }
}

