/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portlet;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.monitoring.internal.statistics.portlet.CompanyStatistics;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={ServerStatisticsHelper.class})
public class ServerStatisticsHelper {
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Map<Long, CompanyStatistics> _companyStatisticsByCompanyId = new TreeMap<Long, CompanyStatistics>();
    private final Map<String, CompanyStatistics> _companyStatisticsByWebId = new TreeMap<String, CompanyStatistics>();

    public Set<Long> getCompanyIds() {
        return this._companyStatisticsByCompanyId.keySet();
    }

    public CompanyStatistics getCompanyStatistics(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for company ID " + companyId);
        }
        return companyStatistics;
    }

    public CompanyStatistics getCompanyStatistics(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for web ID " + webId);
        }
        return companyStatistics;
    }

    public CompanyStatistics getCompanyStatisticsByCompanyId(long companyId) {
        return this._companyStatisticsByCompanyId.get(companyId);
    }

    public Set<CompanyStatistics> getCompanyStatisticsSet() {
        return new HashSet<CompanyStatistics>(this._companyStatisticsByWebId.values());
    }

    public Set<String> getPortletIds() {
        HashSet<String> portletIds = new HashSet<String>();
        for (CompanyStatistics containerStatistics : this._companyStatisticsByWebId.values()) {
            portletIds.addAll(containerStatistics.getPortletIds());
        }
        return portletIds;
    }

    public Set<String> getWebIds() {
        return this._companyStatisticsByWebId.keySet();
    }

    public synchronized CompanyStatistics register(String webId) {
        CompanyStatistics companyStatistics = new CompanyStatistics(this._companyLocalService, webId);
        this._companyStatisticsByCompanyId.put(companyStatistics.getCompanyId(), companyStatistics);
        this._companyStatisticsByWebId.put(webId, companyStatistics);
        return companyStatistics;
    }

    public void reset() {
        this._companyLocalService.forEachCompanyId(companyId -> this.reset((long)companyId), ArrayUtil.toLongArray(this._companyStatisticsByCompanyId.keySet()));
    }

    public void reset(long companyId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public void reset(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public synchronized void unregister(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.remove(webId);
        if (companyStatistics != null) {
            this._companyStatisticsByCompanyId.remove(companyStatistics.getCompanyId());
        }
    }

    @Activate
    protected void activate() {
        CompanyStatistics companyStatistics = new CompanyStatistics();
        this._companyStatisticsByCompanyId.put(companyStatistics.getCompanyId(), companyStatistics);
        this._companyStatisticsByWebId.put(companyStatistics.getWebId(), companyStatistics);
    }
}

