/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.jmx;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.monitoring.internal.statistics.SummaryStatistics;
import com.liferay.portal.monitoring.internal.statistics.jmx.PortalManagerMBean;
import com.liferay.portal.monitoring.internal.statistics.portal.CompanyStatistics;
import com.liferay.portal.monitoring.internal.statistics.portal.ServerStatisticsHelper;
import com.liferay.portal.monitoring.internal.statistics.portal.ServerSummaryStatistics;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"jmx.objectname=com.liferay.portal.monitoring:classification=portal_statistic,name=PortalManager", "jmx.objectname.cache.key=PortalManager"}, service={DynamicMBean.class})
public class PortalManager
extends StandardMBean
implements PortalManagerMBean {
    @Reference
    private ServerStatisticsHelper _serverStatisticsHelper;
    private SummaryStatistics _serverSummaryStatistics;

    public PortalManager() throws NotCompliantMBeanException {
        super(PortalManagerMBean.class);
    }

    @Override
    public long getAverageTime() throws MonitoringException {
        return this._serverSummaryStatistics.getAverageTime();
    }

    @Override
    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getAverageTimeByCompany(companyId);
    }

    @Override
    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getAverageTimeByCompany(webId);
    }

    @Override
    public long[] getCompanyIds() {
        Set<Long> companyIds = this._serverStatisticsHelper.getCompanyIds();
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[0]));
    }

    @Override
    public long getErrorCount() throws MonitoringException {
        return this._serverSummaryStatistics.getErrorCount();
    }

    @Override
    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getErrorCountByCompany(companyId);
    }

    @Override
    public long getErrorCountByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getErrorCountByCompany(webId);
    }

    @Override
    public long getMaxTime() throws MonitoringException {
        return this._serverSummaryStatistics.getMaxTime();
    }

    @Override
    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getMaxTimeByCompany(companyId);
    }

    @Override
    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getMaxTimeByCompany(webId);
    }

    @Override
    public long getMinTime() throws MonitoringException {
        return this._serverSummaryStatistics.getMinTime();
    }

    @Override
    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getMinTimeByCompany(companyId);
    }

    @Override
    public long getMinTimeByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getMinTimeByCompany(webId);
    }

    @Override
    public long getRequestCount() throws MonitoringException {
        return this._serverSummaryStatistics.getRequestCount();
    }

    @Override
    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getRequestCountByCompany(companyId);
    }

    @Override
    public long getRequestCountByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getRequestCountByCompany(webId);
    }

    public long getStartTime(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(companyId);
        return companyStatistics.getStartTime();
    }

    public long getStartTime(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(webId);
        return companyStatistics.getStartTime();
    }

    @Override
    public long getSuccessCount() throws MonitoringException {
        return this._serverSummaryStatistics.getSuccessCount();
    }

    @Override
    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getSuccessCountByCompany(companyId);
    }

    @Override
    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getSuccessCountByCompany(webId);
    }

    @Override
    public long getTimeoutCount() throws MonitoringException {
        return this._serverSummaryStatistics.getTimeoutCount();
    }

    @Override
    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        return this._serverSummaryStatistics.getTimeoutCountByCompany(companyId);
    }

    @Override
    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        return this._serverSummaryStatistics.getTimeoutCountByCompany(webId);
    }

    @Override
    public long getUptime(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(companyId);
        return companyStatistics.getUptime();
    }

    @Override
    public long getUptime(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(webId);
        return companyStatistics.getUptime();
    }

    @Override
    public String[] getWebIds() {
        Set<String> webIds = this._serverStatisticsHelper.getWebIds();
        return webIds.toArray(new String[0]);
    }

    @Override
    public void reset() {
        this._serverStatisticsHelper.reset();
    }

    @Override
    public void reset(long companyId) {
        this._serverStatisticsHelper.reset(companyId);
    }

    @Override
    public void reset(String webId) {
        this._serverStatisticsHelper.reset(webId);
    }

    @Activate
    protected void activate() {
        this._serverSummaryStatistics = new ServerSummaryStatistics(this._serverStatisticsHelper);
    }
}

