/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.servlet.filter;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleFactory;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.monitoring.internal.BaseDataSample;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import com.liferay.portal.monitoring.internal.statistics.portal.PortalRequestDataSample;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, enabled=false, property={"after-filter=Absolute Redirects Filter", "dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=Monitoring Filter", "url-pattern=/c/*", "url-pattern=/group/*", "url-pattern=/user/*", "url-pattern=/web/*"}, service={Filter.class})
public class MonitoringFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(MonitoringFilter.class);
    private static final ThreadLocal<AtomicInteger> _processFilterCount = new CentralizedThreadLocal(String.valueOf(MonitoringFilter.class) + "._processFilterCount", AtomicInteger::new);
    @Reference
    private DataSampleFactory _dataSampleFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private MessageBus _messageBus;
    private volatile MonitoringConfiguration _monitoringConfiguration;
    @Reference
    private Portal _portal;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
        this.setFilterEnabled(this._monitoringConfiguration.monitorPortalRequest() || this._monitoringConfiguration.monitorPortletActionRequest() || this._monitoringConfiguration.monitorPortletEventRequest() || this._monitoringConfiguration.monitorPortletRenderRequest() || this._monitoringConfiguration.monitorPortletResourceRequest() || this._monitoringConfiguration.monitorServiceRequest());
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        BaseDataSample portalRequestDataSample = null;
        this._incrementProcessFilterCount();
        if (this._monitoringConfiguration.monitorPortalRequest()) {
            portalRequestDataSample = (PortalRequestDataSample)this._dataSampleFactory.createPortalRequestDataSample(this._portal.getCompanyId(httpServletRequest), this._getGroupId(httpServletRequest), httpServletRequest.getHeader("Referer"), httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteUser(), httpServletRequest.getRequestURI(), GetterUtil.getString((Object)httpServletRequest.getRequestURL()), httpServletRequest.getHeader("User-Agent"));
            DataSampleThreadLocal.initialize();
        }
        try {
            if (portalRequestDataSample != null) {
                portalRequestDataSample.prepare();
            }
            this.processFilter(MonitoringFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            if (portalRequestDataSample != null) {
                portalRequestDataSample.capture(RequestStatus.SUCCESS);
                portalRequestDataSample.setGroupId(this._getGroupId(httpServletRequest));
                ((PortalRequestDataSample)portalRequestDataSample).setStatusCode(httpServletResponse.getStatus());
            }
        }
        catch (Exception exception) {
            if (portalRequestDataSample != null) {
                portalRequestDataSample.capture(RequestStatus.ERROR);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
            throw new ServletException("Unable to execute request", (Throwable)exception);
        }
        finally {
            if (portalRequestDataSample != null) {
                DataSampleThreadLocal.addDataSample((DataSample)portalRequestDataSample);
            }
            if (this._decrementProcessFilterCount() == 0) {
                Message message = new Message();
                message.setPayload((Object)DataSampleThreadLocal.getDataSamples());
                this._messageBus.sendMessage("liferay/monitoring", message);
                _processFilterCount.remove();
            }
        }
    }

    private int _decrementProcessFilterCount() {
        AtomicInteger processFilterCount = _processFilterCount.get();
        return processFilterCount.decrementAndGet();
    }

    private long _getGroupId(HttpServletRequest httpServletRequest) {
        long groupId;
        block5: {
            groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            if (groupId > 0L) {
                return groupId;
            }
            Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            if (layout != null) {
                return layout.getGroupId();
            }
            long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_l_id");
            if (plid > 0L) {
                try {
                    layout = this._layoutLocalService.getLayout(plid);
                    groupId = layout.getGroupId();
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)("Unable to retrieve layout " + plid), (Throwable)portalException);
                }
            }
        }
        return groupId;
    }

    private void _incrementProcessFilterCount() {
        AtomicInteger processFilterCount = _processFilterCount.get();
        processFilterCount.incrementAndGet();
    }
}

